/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms.reduction;

import com.github.davidmoten.grumpy.core.Position;
import com.github.davidmoten.grumpy.projection.Projector;
import com.github.davidmoten.grumpy.wms.WmsUtil;
import com.github.davidmoten.grumpy.wms.reduction.RectangleSampler;
import com.github.davidmoten.grumpy.wms.reduction.RectangleUtil;
import com.github.davidmoten.grumpy.wms.reduction.ValueRenderer;
import com.google.common.base.Function;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public class Reducer {
    public static <T> void render(Graphics2D g, Function<Position, T> function, Projector projector, RectangleSampler sampler, ValueRenderer<T> regionRenderer) {
        Rectangle region = WmsUtil.toTargetRectangle(projector);
        Reducer.renderRegion(g, function, projector, region, sampler, regionRenderer);
    }

    private static <T> void renderRegion(Graphics2D g, Function<Position, T> function, Projector projector, Rectangle region, RectangleSampler sampler, ValueRenderer<T> regionRenderer) {
        boolean regionDivisible = region.height > 1 || region.width > 1;
        Object regionUniformValue = !regionDivisible ? function.apply((Object)projector.toPosition(region.getMinX(), region.getMinY())) : Reducer.getUniformSampledValue(projector, region, sampler, function);
        if (regionUniformValue != null) {
            regionRenderer.render(g, projector, region, regionUniformValue);
        } else {
            Reducer.splitRegionAndRender(g, function, projector, region, sampler, regionRenderer);
        }
    }

    private static <T> void splitRegionAndRender(Graphics2D g, Function<Position, T> function, Projector projector, Rectangle region, RectangleSampler sampler, ValueRenderer<T> regionRenderer) {
        List<Rectangle> regions = Reducer.splitRegion(region);
        for (Rectangle subRegion : regions) {
            Reducer.renderRegion(g, function, projector, subRegion, sampler, regionRenderer);
        }
    }

    private static List<Rectangle> splitRegion(Rectangle region) {
        if (region.width > 1 && region.height > 1) {
            return RectangleUtil.quarter(region);
        }
        if (region.height > 1) {
            return RectangleUtil.splitVertically(region);
        }
        return RectangleUtil.splitHorizontally(region);
    }

    private static <T> T getUniformSampledValue(Projector projector, Rectangle region, RectangleSampler sampler, Function<Position, T> function) {
        Object firstT = null;
        List<Point> points = sampler.sample(region, projector);
        for (Point point : points) {
            Position p = projector.toPosition((double)point.x, (double)point.y);
            Object t = function.apply((Object)p);
            if (firstT == null) {
                firstT = t;
                continue;
            }
            if (firstT.equals(t)) continue;
            return null;
        }
        return (T)firstT;
    }
}

