/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmc24.gradle.plugin.avro;

import com.github.davidmc24.gradle.plugin.avro.GradleFeatures;
import com.github.davidmc24.gradle.plugin.avro.SetBuilder;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.idea.model.IdeaModule;

class GradleCompatibility {
    private static final Class<?>[] NO_PARAMETERS = new Class[0];
    private static final Object[] NO_ARGUMENTS = new Object[0];

    GradleCompatibility() {
    }

    static <T> T createExtensionWithObjectFactory(Project project, String extensionName, Class<T> extensionType) {
        if (GradleFeatures.projectIntoExtensionInjection.isSupported()) {
            return (T)project.getExtensions().create(extensionName, extensionType, new Object[0]);
        }
        return (T)project.getExtensions().create(extensionName, extensionType, new Object[]{project, project.getObjects()});
    }

    static ConfigurableFileCollection createConfigurableFileCollection(Project project) {
        if (GradleFeatures.objectFactoryFileCollection.isSupported()) {
            return project.getObjects().fileCollection();
        }
        Class[] parameterTypes = new Class[]{Object[].class};
        Object[] args = new Object[]{new Object[0]};
        return (ConfigurableFileCollection)GradleCompatibility.invokeMethod(project.getLayout(), "configurableFiles", parameterTypes, args);
    }

    static String getSourcesJarTaskName(SourceSet sourceSet) {
        if (GradleFeatures.getSourcesJarTaskName.isSupported()) {
            return sourceSet.getSourcesJarTaskName();
        }
        return sourceSet.getTaskName(null, "sourcesJar");
    }

    static void addTestSources(IdeaModule module, File ... files) {
        if (GradleFeatures.ideaModuleTestSources.isSupported()) {
            Object testSources = GradleCompatibility.invokeMethod(module, "getTestSources", NO_PARAMETERS, NO_ARGUMENTS);
            Class[] parameterTypes = new Class[]{Object[].class};
            Object[] args = new Object[]{files};
            GradleCompatibility.invokeMethod(testSources, "from", parameterTypes, args);
        } else {
            module.setTestSourceDirs(new SetBuilder().addAll(module.getTestSourceDirs()).addAll(files).build());
        }
    }

    private static <T> T invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] args) {
        try {
            Method method = object.getClass().getMethod(methodName, parameterTypes);
            return (T)method.invoke(object, args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Failed to invoke method via reflection", ex);
        }
    }
}

