/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmc24.gradle.plugin.avro;

import com.github.davidmc24.gradle.plugin.avro.Constants;
import com.github.davidmc24.gradle.plugin.avro.Enums;
import com.github.davidmc24.gradle.plugin.avro.FileExtensionSpec;
import com.github.davidmc24.gradle.plugin.avro.FileUtils;
import com.github.davidmc24.gradle.plugin.avro.GradleCompatibility;
import com.github.davidmc24.gradle.plugin.avro.OutputDirTask;
import com.github.davidmc24.gradle.plugin.avro.ProcessingState;
import com.github.davidmc24.gradle.plugin.avro.SchemaResolver;
import com.github.davidmc24.gradle.plugin.avro.SetBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class GenerateAvroJavaTask
extends OutputDirTask {
    private static Set<String> SUPPORTED_EXTENSIONS = new SetBuilder<String>().add("avpr").add("avsc").build();
    private final Property<String> outputCharacterEncoding;
    private final Property<String> stringType;
    private final Property<String> fieldVisibility;
    private final Property<String> templateDirectory;
    private final ListProperty<String> additionalVelocityToolClasses;
    private final Property<Boolean> createOptionalGetters;
    private final Property<Boolean> gettersReturnOptional;
    private final Property<Boolean> optionalGettersForNullableFieldsOnly;
    private final Property<Boolean> createSetters;
    private final Property<Boolean> enableDecimalLogicalType;
    private FileCollection classpath;
    private final ConfigurableFileCollection conversionsAndTypeFactoriesClasspath;
    private final MapProperty<String, Class<? extends LogicalTypes.LogicalTypeFactory>> logicalTypeFactories;
    private final MapProperty<String, String> logicalTypeFactoryClassNames;
    private final ListProperty<Class<? extends Conversion<?>>> customConversions;
    private final ListProperty<String> customConversionClassNames;
    private final Provider<GenericData.StringType> stringTypeProvider;
    private final Provider<SpecificCompiler.FieldVisibility> fieldVisibilityProvider;
    private final ProjectLayout projectLayout;
    private final SchemaResolver resolver;

    @Inject
    public GenerateAvroJavaTask(ObjectFactory objects) {
        this.outputCharacterEncoding = objects.property(String.class);
        this.stringType = objects.property(String.class).convention((Object)Constants.DEFAULT_STRING_TYPE);
        this.fieldVisibility = objects.property(String.class).convention((Object)Constants.DEFAULT_FIELD_VISIBILITY);
        this.templateDirectory = objects.property(String.class);
        this.additionalVelocityToolClasses = objects.listProperty(String.class).convention(Collections.emptyList());
        this.createOptionalGetters = objects.property(Boolean.class).convention((Object)false);
        this.gettersReturnOptional = objects.property(Boolean.class).convention((Object)false);
        this.optionalGettersForNullableFieldsOnly = objects.property(Boolean.class).convention((Object)false);
        this.createSetters = objects.property(Boolean.class).convention((Object)true);
        this.enableDecimalLogicalType = objects.property(Boolean.class).convention((Object)true);
        this.classpath = GradleCompatibility.createConfigurableFileCollection(this.getProject());
        this.conversionsAndTypeFactoriesClasspath = GradleCompatibility.createConfigurableFileCollection(this.getProject());
        this.logicalTypeFactories = objects.mapProperty(String.class, Constants.LOGICAL_TYPE_FACTORY_TYPE.getConcreteClass()).convention(Constants.DEFAULT_LOGICAL_TYPE_FACTORIES);
        this.logicalTypeFactoryClassNames = objects.mapProperty(String.class, String.class).convention(Constants.DEFAULT_LOGICAL_TYPE_FACTORY_CLASS_NAMES);
        this.customConversions = objects.listProperty(Constants.CONVERSION_TYPE.getConcreteClass()).convention(Constants.DEFAULT_CUSTOM_CONVERSIONS);
        this.customConversionClassNames = objects.listProperty(String.class).convention(Constants.DEFAULT_CUSTOM_CONVERSION_CLASS_NAMES);
        this.stringTypeProvider = this.getStringType().map(input -> (GenericData.StringType)Enums.parseCaseInsensitive((String)"stringType", (Enum[])GenericData.StringType.values(), (String)input));
        this.fieldVisibilityProvider = this.getFieldVisibility().map(input -> (SpecificCompiler.FieldVisibility)Enums.parseCaseInsensitive((String)"fieldVisibility", (Enum[])SpecificCompiler.FieldVisibility.values(), (String)input));
        this.projectLayout = this.getProject().getLayout();
        this.resolver = new SchemaResolver(this.projectLayout, this.getLogger());
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    public void classpath(Object ... paths) {
        this.classpath.plus((FileCollection)this.getProject().files(paths));
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Optional
    @Input
    public Property<String> getOutputCharacterEncoding() {
        return this.outputCharacterEncoding;
    }

    public void setOutputCharacterEncoding(String outputCharacterEncoding) {
        this.outputCharacterEncoding.set((Object)outputCharacterEncoding);
    }

    public void setOutputCharacterEncoding(Charset outputCharacterEncoding) {
        this.setOutputCharacterEncoding(outputCharacterEncoding.name());
    }

    @Input
    public Property<String> getStringType() {
        return this.stringType;
    }

    public void setStringType(GenericData.StringType stringType) {
        this.setStringType(stringType.name());
    }

    public void setStringType(String stringType) {
        this.stringType.set((Object)stringType);
    }

    @Input
    public Property<String> getFieldVisibility() {
        return this.fieldVisibility;
    }

    public void setFieldVisibility(String fieldVisibility) {
        this.fieldVisibility.set((Object)fieldVisibility);
    }

    public void setFieldVisibility(SpecificCompiler.FieldVisibility fieldVisibility) {
        this.setFieldVisibility(fieldVisibility.name());
    }

    @Optional
    @Input
    public Property<String> getTemplateDirectory() {
        return this.templateDirectory;
    }

    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory.set((Object)templateDirectory);
    }

    @Optional
    @Input
    public ListProperty<String> getAdditionalVelocityToolClasses() {
        return this.additionalVelocityToolClasses;
    }

    public void setAdditionalVelocityToolClasses(List<String> additionalVelocityToolClasses) {
        this.additionalVelocityToolClasses.set(additionalVelocityToolClasses);
    }

    public Property<Boolean> isCreateSetters() {
        return this.createSetters;
    }

    @Input
    public Property<Boolean> getCreateSetters() {
        return this.createSetters;
    }

    public void setCreateSetters(String createSetters) {
        this.createSetters.set((Object)Boolean.parseBoolean(createSetters));
    }

    public Property<Boolean> isCreateOptionalGetters() {
        return this.createOptionalGetters;
    }

    @Input
    public Property<Boolean> getCreateOptionalGetters() {
        return this.createOptionalGetters;
    }

    public void setCreateOptionalGetters(String createOptionalGetters) {
        this.createOptionalGetters.set((Object)Boolean.parseBoolean(createOptionalGetters));
    }

    public Property<Boolean> isGettersReturnOptional() {
        return this.gettersReturnOptional;
    }

    @Input
    public Property<Boolean> getGettersReturnOptional() {
        return this.gettersReturnOptional;
    }

    public void setGettersReturnOptional(String gettersReturnOptional) {
        this.gettersReturnOptional.set((Object)Boolean.parseBoolean(gettersReturnOptional));
    }

    public Property<Boolean> isOptionalGettersForNullableFieldsOnly() {
        return this.optionalGettersForNullableFieldsOnly;
    }

    @Input
    public Property<Boolean> getOptionalGettersForNullableFieldsOnly() {
        return this.optionalGettersForNullableFieldsOnly;
    }

    public void setOptionalGettersForNullableFieldsOnly(String optionalGettersForNullableFieldsOnly) {
        this.optionalGettersForNullableFieldsOnly.set((Object)Boolean.parseBoolean(optionalGettersForNullableFieldsOnly));
    }

    public Property<Boolean> isEnableDecimalLogicalType() {
        return this.enableDecimalLogicalType;
    }

    @Input
    public Property<Boolean> getEnableDecimalLogicalType() {
        return this.enableDecimalLogicalType;
    }

    public void setEnableDecimalLogicalType(String enableDecimalLogicalType) {
        this.enableDecimalLogicalType.set((Object)Boolean.parseBoolean(enableDecimalLogicalType));
    }

    @Optional
    @Classpath
    public ConfigurableFileCollection getConversionsAndTypeFactoriesClasspath() {
        return this.conversionsAndTypeFactoriesClasspath;
    }

    @Deprecated
    @Optional
    @Input
    public MapProperty<String, Class<? extends LogicalTypes.LogicalTypeFactory>> getLogicalTypeFactories() {
        return this.logicalTypeFactories;
    }

    @Deprecated
    public void setLogicalTypeFactories(Provider<? extends Map<? extends String, ? extends Class<? extends LogicalTypes.LogicalTypeFactory>>> provider) {
        this.logicalTypeFactories.set(provider);
    }

    @Deprecated
    public void setLogicalTypeFactories(Map<? extends String, ? extends Class<? extends LogicalTypes.LogicalTypeFactory>> logicalTypeFactories) {
        this.logicalTypeFactories.set(logicalTypeFactories);
    }

    @Input
    @Optional
    public MapProperty<String, String> getLogicalTypeFactoryClassNames() {
        return this.logicalTypeFactoryClassNames;
    }

    public void setLogicalTypeFactoryClassNames(Provider<? extends Map<? extends String, ? extends String>> provider) {
        this.logicalTypeFactoryClassNames.set(provider);
    }

    public void setLogicalTypeFactoryClassNames(Map<? extends String, ? extends String> logicalTypeFactoryClassNames) {
        this.logicalTypeFactoryClassNames.set(logicalTypeFactoryClassNames);
    }

    @Deprecated
    @Optional
    @Input
    public ListProperty<Class<? extends Conversion<?>>> getCustomConversions() {
        return this.customConversions;
    }

    @Deprecated
    public void setCustomConversions(Provider<Iterable<Class<? extends Conversion<?>>>> provider) {
        this.customConversions.set(provider);
    }

    @Deprecated
    public void setCustomConversions(Iterable<Class<? extends Conversion<?>>> customConversions) {
        this.customConversions.set(customConversions);
    }

    @Optional
    @Input
    public ListProperty<String> getCustomConversionClassNames() {
        return this.customConversionClassNames;
    }

    public void setCustomConversionClassNames(Provider<Iterable<String>> provider) {
        this.customConversionClassNames.set(provider);
    }

    public void setCustomConversionClassNames(Iterable<String> customConversionClassNames) {
        this.customConversionClassNames.set(customConversionClassNames);
    }

    @TaskAction
    protected void process() {
        this.getLogger().debug("Using outputCharacterEncoding {}", this.getOutputCharacterEncoding().getOrNull());
        this.getLogger().debug("Using stringType {}", (Object)((GenericData.StringType)this.stringTypeProvider.get()).name());
        this.getLogger().debug("Using fieldVisibility {}", (Object)((SpecificCompiler.FieldVisibility)this.fieldVisibilityProvider.get()).name());
        this.getLogger().debug("Using templateDirectory '{}'", this.getTemplateDirectory().getOrNull());
        this.getLogger().debug("Using additionalVelocityToolClasses '{}'", this.getAdditionalVelocityToolClasses().getOrNull());
        this.getLogger().debug("Using createSetters {}", this.isCreateSetters().get());
        this.getLogger().debug("Using createOptionalGetters {}", this.isCreateOptionalGetters().get());
        this.getLogger().debug("Using gettersReturnOptional {}", this.isGettersReturnOptional().get());
        this.getLogger().debug("Using optionalGettersForNullableFieldsOnly {}", this.isOptionalGettersForNullableFieldsOnly().get());
        this.getLogger().debug("Using enableDecimalLogicalType {}", this.isEnableDecimalLogicalType().get());
        this.getLogger().debug("Using logicalTypeFactories {}", ((Map)this.logicalTypeFactories.get()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Class)e.getValue()).getName())));
        this.getLogger().debug("Using customConversions {}", ((List)this.customConversions.get()).stream().map(v -> v.getName()).collect(Collectors.toList()));
        this.getLogger().info("Found {} files", (Object)this.getInputs().getSourceFiles().getFiles().size());
        this.failOnUnsupportedFiles();
        this.processFiles();
    }

    private void failOnUnsupportedFiles() {
        FileCollection unsupportedFiles = this.filterSources((Spec<? super File>)new NotSpec((Spec)new FileExtensionSpec(SUPPORTED_EXTENSIONS)));
        if (!unsupportedFiles.isEmpty()) {
            throw new GradleException(String.format("Unsupported file extension for the following files: %s", unsupportedFiles));
        }
    }

    private void processFiles() {
        this.registerLogicalTypes();
        int processedFileCount = 0;
        processedFileCount += this.processProtoFiles();
        this.setDidWork((processedFileCount += this.processSchemaFiles()) > 0);
    }

    private int processProtoFiles() {
        int processedFileCount = 0;
        for (File sourceFile : this.filterSources(new FileExtensionSpec("avpr"))) {
            this.processProtoFile(sourceFile);
            ++processedFileCount;
        }
        return processedFileCount;
    }

    private void processProtoFile(File sourceFile) {
        this.getLogger().info("Processing {}", (Object)sourceFile);
        try {
            this.compile(new SpecificCompiler(Protocol.parse((File)sourceFile)), sourceFile);
        }
        catch (IOException ex) {
            throw new GradleException(String.format("Failed to compile protocol definition file %s", sourceFile), (Throwable)ex);
        }
    }

    private int processSchemaFiles() {
        Set files = this.filterSources(new FileExtensionSpec("avsc")).getFiles();
        ProcessingState processingState = this.resolver.resolve(files);
        for (File file : files) {
            String path = FileUtils.projectRelativePath(this.projectLayout, file);
            for (Schema schema : processingState.getSchemasForLocation(path)) {
                try {
                    this.compile(new SpecificCompiler(schema), file);
                }
                catch (IOException ex) {
                    throw new GradleException(String.format("Failed to compile schema definition file %s", path), (Throwable)ex);
                }
            }
        }
        return processingState.getProcessedTotal();
    }

    private void compile(SpecificCompiler compiler, File sourceFile) throws IOException {
        compiler.setOutputCharacterEncoding((String)this.getOutputCharacterEncoding().getOrNull());
        compiler.setStringType((GenericData.StringType)this.stringTypeProvider.get());
        compiler.setFieldVisibility((SpecificCompiler.FieldVisibility)this.fieldVisibilityProvider.get());
        if (this.getTemplateDirectory().isPresent()) {
            compiler.setTemplateDir((String)this.getTemplateDirectory().get());
        }
        if (this.getAdditionalVelocityToolClasses().isPresent()) {
            ClassLoader loader = this.assembleClassLoader();
            List tools = ((List)this.getAdditionalVelocityToolClasses().get()).stream().map(s -> {
                try {
                    return Class.forName(s, true, loader);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("unable to load velocity tool class " + s, e);
                }
            }).map(aClass -> {
                try {
                    return aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Unable to instantiate velocity tool class using default constructor: " + aClass, e);
                }
            }).collect(Collectors.toList());
            compiler.setAdditionalVelocityTools(tools);
        }
        compiler.setCreateOptionalGetters(((Boolean)this.createOptionalGetters.get()).booleanValue());
        compiler.setGettersReturnOptional(((Boolean)this.gettersReturnOptional.get()).booleanValue());
        compiler.setOptionalGettersForNullableFieldsOnly(((Boolean)this.optionalGettersForNullableFieldsOnly.get()).booleanValue());
        compiler.setCreateSetters(((Boolean)this.isCreateSetters().get()).booleanValue());
        compiler.setEnableDecimalLogicalType(((Boolean)this.isEnableDecimalLogicalType().get()).booleanValue());
        this.registerCustomConversions(compiler);
        compiler.compileToDestination(sourceFile, ((Directory)this.getOutputDir().get()).getAsFile());
    }

    private void registerLogicalTypes() {
        Map<String, Class<? extends LogicalTypes.LogicalTypeFactory>> logicalTypeFactoryMap = this.resolveLocalTypeFactories();
        Set<Map.Entry<String, Class<? extends LogicalTypes.LogicalTypeFactory>>> logicalTypeFactoryEntries = logicalTypeFactoryMap.entrySet();
        for (Map.Entry<String, Class<? extends LogicalTypes.LogicalTypeFactory>> entry : logicalTypeFactoryEntries) {
            String logicalTypeName = entry.getKey();
            Class<? extends LogicalTypes.LogicalTypeFactory> logicalTypeFactoryClass = entry.getValue();
            try {
                LogicalTypes.LogicalTypeFactory logicalTypeFactory = logicalTypeFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LogicalTypes.register((String)logicalTypeName, (LogicalTypes.LogicalTypeFactory)logicalTypeFactory);
            }
            catch (ReflectiveOperationException ex) {
                this.getLogger().error("Could not instantiate logicalTypeFactory class \"" + logicalTypeFactoryClass.getName() + "\"");
            }
        }
    }

    private Map<String, Class<? extends LogicalTypes.LogicalTypeFactory>> resolveLocalTypeFactories() {
        HashMap<String, Class<? extends LogicalTypes.LogicalTypeFactory>> result = new HashMap<String, Class<? extends LogicalTypes.LogicalTypeFactory>>();
        if (this.logicalTypeFactoryClassNames.isPresent()) {
            ClassLoader typeFactoriesClassLoader = this.createConversionsAndTypeFactoriesClassLoader();
            for (Map.Entry entry : ((Map)this.logicalTypeFactoryClassNames.get()).entrySet()) {
                String logicalTypeFactoryClassName = (String)entry.getValue();
                try {
                    Class<?> aClass = Class.forName(logicalTypeFactoryClassName, true, typeFactoriesClassLoader);
                    result.put((String)entry.getKey(), (Class<? extends LogicalTypes.LogicalTypeFactory>)aClass);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to load logical type factory class " + logicalTypeFactoryClassName, e);
                }
            }
        }
        result.putAll((Map)this.logicalTypeFactories.get());
        return result;
    }

    private void registerCustomConversions(SpecificCompiler compiler) {
        this.loadCustomConversionClasses().forEach(arg_0 -> ((SpecificCompiler)compiler).addCustomConversion(arg_0));
        ((List)this.customConversions.get()).forEach(arg_0 -> ((SpecificCompiler)compiler).addCustomConversion(arg_0));
    }

    private List<Class<?>> loadCustomConversionClasses() {
        if (this.customConversionClassNames.isPresent()) {
            ClassLoader customConversionsClassLoader = this.createConversionsAndTypeFactoriesClassLoader();
            return ((List)this.customConversionClassNames.get()).stream().map(conversionClassName -> {
                try {
                    return Class.forName(conversionClassName, true, customConversionsClassLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to load custom conversion class " + conversionClassName, e);
                }
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private ClassLoader createConversionsAndTypeFactoriesClassLoader() {
        URL[] urls = (URL[])this.conversionsAndTypeFactoriesClasspath.getFiles().stream().map(File::toURI).map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Unable to resolve URL in conversions and type factories classpath", e);
            }
        }).toArray(URL[]::new);
        return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private ClassLoader assembleClassLoader() {
        this.getLogger().debug("Using additional classpath: {}", (Object)this.classpath.getFiles());
        LinkedList<URL> urls = new LinkedList<URL>();
        for (File file : this.classpath) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLogger().debug(e.getMessage());
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }
}

