/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidepastore.liferay.converter;

import com.github.davidepastore.liferay.annotation.JournalArticleField;
import com.github.davidepastore.liferay.model.DDMDocumentAndMedia;
import com.github.davidepastore.liferay.model.DDMGeolocation;
import com.github.davidepastore.liferay.model.DDMImage;
import com.github.davidepastore.liferay.util.JsonUtil;
import com.github.davidepastore.liferay.util.SimpleLocaleUtil;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConvertibleJournalArticle {
    private static Log log = LogFactoryUtil.getLog(ConvertibleJournalArticle.class);

    public void fromJournalArticle(JournalArticle journalArticle) throws Exception {
        this.fromJournalArticle(journalArticle, SimpleLocaleUtil.buildLocale(journalArticle.getDefaultLanguageId()));
    }

    public void fromJournalArticle(JournalArticle journalArticle, Locale locale) throws Exception {
        log.debug((Object)("Not localized content: " + journalArticle.getContent()));
        log.debug((Object)("Localized content: " + journalArticle.getContentByLocale(locale.getLanguage())));
        String content = journalArticle.getContentByLocale(locale.getLanguage());
        Document document = Jsoup.parse((String)content, (String)"", (Parser)Parser.xmlParser());
        Elements elements = document.select("root > dynamic-element");
        this.setValueFromElements(elements, this, journalArticle.getTitle(locale));
        log.debug((Object)("Object: " + this));
    }

    protected void setValueFromElements(Elements elements, Object object, String title) throws IllegalArgumentException, IllegalAccessException, InstantiationException, JsonSyntaxException, JsonIOException, IndexOutOfBoundsException, FileNotFoundException {
        List<String> names = this.getDynamicElementNames(elements);
        ArrayList value = null;
        for (String name : names) {
            Elements elementsWithName = elements.select("[name=" + name + "]");
            ArrayList listValue = new ArrayList();
            int counter = 0;
            int size = elementsWithName.size();
            boolean isList = this.isListInObject(name, object) || size > 1;
            for (Element element : elementsWithName) {
                String type = element.attr("type");
                if (type.equals("list")) {
                    isList = false;
                }
                value = this.getObjectValue(element, object, title);
                boolean setValue = true;
                if (isList) {
                    listValue.add(value);
                    if (++counter == size) {
                        setValue = true;
                        value = listValue;
                    } else {
                        setValue = false;
                    }
                }
                if (setValue) {
                    List<Field> linkedFields = this.getLinkedFields(name, object.getClass());
                    for (Field linkedField : linkedFields) {
                        linkedField.setAccessible(true);
                        linkedField.set(object, value);
                    }
                }
                List<Field> titleFields = this.getTitleFields();
                for (Field titleField : titleFields) {
                    titleField.setAccessible(true);
                    titleField.set(object, title);
                }
                List<Field> baseFields = this.getBaseFields(object.getClass());
                for (Field baseField : baseFields) {
                    baseField.setAccessible(true);
                    Object baseValue = this.getObjectValue(elements.first().parent().select("> dynamic-content").first(), object, title);
                    baseField.set(object, baseValue);
                }
            }
        }
    }

    protected Object getObjectValue(Element element, Object object, String title) throws InstantiationException, IllegalAccessException, NumberFormatException, IndexOutOfBoundsException, JsonSyntaxException, JsonIOException, FileNotFoundException {
        Elements nestedElements;
        ArrayList<String> value = null;
        String type = element.attr("type");
        String stringValue = element.text();
        if (element.tagName().equals("dynamic-content")) {
            type = element.parent().attr("type");
        }
        if (!(nestedElements = element.children().select("dynamic-element")).isEmpty()) {
            String parentName = element.attr("name");
            List<Field> fields = this.getLinkedFields(parentName, object.getClass());
            for (Field field : fields) {
                field.setAccessible(true);
                Class clazzType = field.getType();
                log.debug((Object)("clazzType: " + clazzType));
                if (clazzType.getName().equals("java.util.List")) {
                    log.debug((Object)"This seems a list!");
                    ParameterizedType listType = (ParameterizedType)field.getGenericType();
                    clazzType = (Class)listType.getActualTypeArguments()[0];
                }
                Object nestedObject = clazzType.newInstance();
                this.setValueFromElements(nestedElements, nestedObject, title);
                value = nestedObject;
            }
        } else if (type.equals("text")) {
            value = stringValue;
        } else if (type.equals("boolean")) {
            value = Boolean.parseBoolean(stringValue);
        } else if (type.equals("ddm-date")) {
            value = new Date(Long.parseLong(stringValue));
        } else if (type.equals("ddm-decimal")) {
            value = new Double(stringValue);
        } else if (type.equals("image")) {
            DDMImage ddmImage = JsonUtil.getDDMImage(stringValue);
            value = ddmImage;
        } else if (type.equals("document_library")) {
            DDMDocumentAndMedia ddmDocumentAndMedia = JsonUtil.getDDMDocumentAndMedia(stringValue);
            value = ddmDocumentAndMedia;
        } else if (type.equals("ddm-integer")) {
            value = Integer.parseInt(stringValue);
        } else if (type.equals("link_to_layout")) {
            value = stringValue;
        } else if (type.equals("ddm-number")) {
            value = new BigDecimal(stringValue);
        } else if (type.equals("radio")) {
            value = stringValue.substring(2, stringValue.length() - 2);
        } else if (type.equals("list")) {
            Elements options = element.select("dynamic-content option");
            if (options.isEmpty()) {
                value = stringValue;
            } else {
                ArrayList<String> list = new ArrayList<String>();
                for (Element option : options) {
                    list.add(option.text());
                }
                value = list;
            }
        } else if (type.equals("text_box")) {
            value = stringValue;
        } else if (type.equals("text_area")) {
            value = stringValue;
        } else if (type.equals("ddm-geolocation")) {
            DDMGeolocation ddmGeolocation = JsonUtil.getDDMGeolocation(stringValue);
            value = ddmGeolocation;
        }
        return value;
    }

    protected Field getLinkedField(String name, Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            JournalArticleField annotation;
            String fieldName;
            if (!field.isAnnotationPresent(JournalArticleField.class) || !name.equals(fieldName = (annotation = field.getAnnotation(JournalArticleField.class)).name())) continue;
            return field;
        }
        return null;
    }

    protected List<Field> getLinkedFields(String name, Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            JournalArticleField annotation;
            String fieldName;
            if (!field.isAnnotationPresent(JournalArticleField.class) || !name.equals(fieldName = (annotation = field.getAnnotation(JournalArticleField.class)).name())) continue;
            fields.add(field);
        }
        return fields;
    }

    protected List<Field> getTitleFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.getClass().getDeclaredFields()) {
            JournalArticleField annotation;
            if (!field.isAnnotationPresent(JournalArticleField.class) || !(annotation = field.getAnnotation(JournalArticleField.class)).title()) continue;
            fields.add(field);
        }
        return fields;
    }

    protected List<Field> getBaseFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            JournalArticleField annotation;
            if (!field.isAnnotationPresent(JournalArticleField.class) || !(annotation = field.getAnnotation(JournalArticleField.class)).base()) continue;
            fields.add(field);
        }
        return fields;
    }

    protected List<String> getDynamicElementNames(Elements elements) {
        ArrayList<String> names = new ArrayList<String>();
        for (Element element : elements) {
            String name = element.attr("name");
            if (names.contains(name)) continue;
            names.add(name);
        }
        return names;
    }

    protected boolean isListInObject(String name, Object object) {
        Field field = this.getLinkedField(name, object.getClass());
        if (field != null) {
            field.setAccessible(true);
            Class<?> clazzType = field.getType();
            log.debug((Object)("clazzType: " + clazzType));
            if (clazzType.getName().equals("java.util.List")) {
                log.debug((Object)"This seems a list!");
                return true;
            }
        }
        return false;
    }
}

