/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb.measurements;

import java.io.IOException;
import java.util.Collection;
import metrics_influxdb.measurements.AbstractSender;
import metrics_influxdb.measurements.Measurement;
import metrics_influxdb.misc.BoundedFIFO;

public class QueueableSender
extends AbstractSender {
    private final Collection<Measurement> measures;
    private int queueSize;

    protected QueueableSender(int queueSize) {
        this.queueSize = queueSize;
        this.measures = new BoundedFIFO<Measurement>(queueSize);
    }

    @Override
    public void flush() {
        if (this.doSend(this.measures)) {
            this.measures.clear();
        }
    }

    @Override
    public void send(Measurement m) {
        if (m == null) {
            return;
        }
        if (this.measures.size() == this.queueSize && this.doSend(this.measures)) {
            this.measures.clear();
        }
        this.measures.add(m);
    }

    protected boolean doSend(Collection<Measurement> measuresToSend) {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.measures.clear();
    }
}

