/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import metrics_influxdb.Influxdb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxdbReporter
extends ScheduledReporter {
    private static String[] COLUMNS_TIMER = new String[]{"time", "count", "min", "max", "mean", "std-dev", "50-percentile", "75-percentile", "95-percentile", "99-percentile", "999-percentile", "one-minute", "five-minute", "fifteen-minute", "mean-rate"};
    private static String[] COLUMNS_HISTOGRAM = new String[]{"time", "count", "min", "max", "mean", "std-dev", "50-percentile", "75-percentile", "95-percentile", "99-percentile", "999-percentile"};
    private static String[] COLUMNS_COUNT = new String[]{"time", "count"};
    private static String[] COLUMNS_GAUGE = new String[]{"time", "value"};
    private static String[] COLUMNS_METER = new String[]{"time", "count", "one-minute", "five-minute", "fifteen-minute", "mean-rate"};
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluxdbReporter.class);
    private final Influxdb influxdb;
    private final Clock clock;
    private final String prefix;
    private final Object[][] pointsTimer = new Object[][]{{0L, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    private final Object[][] pointsHistogram = new Object[][]{{0L, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    private final Object[][] pointsCounter = new Object[][]{{0L, 0L}};
    private final Object[][] pointsGauge = new Object[][]{{0L, null}};
    private final Object[][] pointsMeter = new Object[][]{{0L, 0, 0.0, 0.0, 0.0, 0.0}};

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private InfluxdbReporter(MetricRegistry registry, Influxdb influxdb, Clock clock, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "influxdb-reporter", filter, rateUnit, durationUnit);
        this.influxdb = influxdb;
        this.clock = clock;
        this.prefix = prefix == null ? "" : prefix.trim() + ".";
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = this.clock.getTime();
        try {
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.reportMeter(entry.getKey(), (Metered)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue(), timestamp);
            }
            this.influxdb.sendRequest(true, false);
        }
        catch (Exception e) {
            this.influxdb.resetRequest();
            LOGGER.warn("Unable to report to InfluxDB, forgot data", (Object)this.influxdb, (Object)e);
        }
    }

    private void reportTimer(String name, Timer timer, long timestamp) throws IOException {
        Snapshot snapshot = timer.getSnapshot();
        Object[] p = this.pointsTimer[0];
        p[0] = timestamp;
        p[1] = snapshot.size();
        p[2] = this.convertDuration(snapshot.getMin());
        p[3] = this.convertDuration(snapshot.getMax());
        p[4] = this.convertDuration(snapshot.getMean());
        p[5] = this.convertDuration(snapshot.getStdDev());
        p[6] = this.convertDuration(snapshot.getMedian());
        p[7] = this.convertDuration(snapshot.get75thPercentile());
        p[8] = this.convertDuration(snapshot.get95thPercentile());
        p[9] = this.convertDuration(snapshot.get99thPercentile());
        p[10] = this.convertDuration(snapshot.get999thPercentile());
        p[11] = this.convertRate(timer.getOneMinuteRate());
        p[12] = this.convertRate(timer.getFiveMinuteRate());
        p[13] = this.convertRate(timer.getFifteenMinuteRate());
        p[14] = this.convertRate(timer.getMeanRate());
        assert (p.length == COLUMNS_TIMER.length);
        this.influxdb.appendSeries(this.prefix, name, ".timer", COLUMNS_TIMER, this.pointsTimer);
    }

    private void reportHistogram(String name, Histogram histogram, long timestamp) throws IOException {
        Snapshot snapshot = histogram.getSnapshot();
        Object[] p = this.pointsHistogram[0];
        p[0] = timestamp;
        p[1] = snapshot.size();
        p[2] = snapshot.getMin();
        p[3] = snapshot.getMax();
        p[4] = snapshot.getMean();
        p[5] = snapshot.getStdDev();
        p[6] = snapshot.getMedian();
        p[7] = snapshot.get75thPercentile();
        p[8] = snapshot.get95thPercentile();
        p[9] = snapshot.get99thPercentile();
        p[10] = snapshot.get999thPercentile();
        assert (p.length == COLUMNS_HISTOGRAM.length);
        this.influxdb.appendSeries(this.prefix, name, ".histogram", COLUMNS_HISTOGRAM, this.pointsHistogram);
    }

    private void reportCounter(String name, Counter counter, long timestamp) throws IOException {
        Object[] p = this.pointsCounter[0];
        p[0] = timestamp;
        p[1] = counter.getCount();
        assert (p.length == COLUMNS_COUNT.length);
        this.influxdb.appendSeries(this.prefix, name, ".count", COLUMNS_COUNT, this.pointsCounter);
    }

    private void reportGauge(String name, Gauge<?> gauge, long timestamp) throws IOException {
        Object[] p = this.pointsGauge[0];
        p[0] = timestamp;
        p[1] = gauge.getValue();
        assert (p.length == COLUMNS_GAUGE.length);
        this.influxdb.appendSeries(this.prefix, name, ".value", COLUMNS_GAUGE, this.pointsGauge);
    }

    private void reportMeter(String name, Metered meter, long timestamp) throws IOException {
        Object[] p = this.pointsMeter[0];
        p[0] = timestamp;
        p[1] = meter.getCount();
        p[2] = this.convertRate(meter.getOneMinuteRate());
        p[3] = this.convertRate(meter.getFiveMinuteRate());
        p[4] = this.convertRate(meter.getFifteenMinuteRate());
        p[5] = this.convertRate(meter.getMeanRate());
        assert (p.length == COLUMNS_METER.length);
        this.influxdb.appendSeries(this.prefix, name, ".meter", COLUMNS_METER, this.pointsMeter);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public InfluxdbReporter build(Influxdb influxdb) {
            return new InfluxdbReporter(this.registry, influxdb, this.clock, this.prefix, this.rateUnit, this.durationUnit, this.filter);
        }
    }
}

