/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;

public class Influxdb {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public final URL url;
    private final StringBuilder json = new StringBuilder();
    public boolean debugJson = false;

    public static char toTimePrecision(TimeUnit t) {
        switch (t) {
            case SECONDS: {
                return 's';
            }
            case MILLISECONDS: {
                return 'm';
            }
            case MICROSECONDS: {
                return 'u';
            }
        }
        throw new IllegalArgumentException("time precision should be SECONDS or MILLISECONDS or MICROSECONDS");
    }

    public Influxdb(String host, int port, String database, String username, String password, TimeUnit timePrecision) throws Exception {
        this(new URL("http", host, port, "/db/" + database + "/series?u=" + URLEncoder.encode(username, UTF_8.name()) + "&p=" + password + "&time_precision=" + Influxdb.toTimePrecision(timePrecision)));
    }

    public Influxdb(URL url) throws Exception {
        this.url = url;
        this.resetRequest();
    }

    public void resetRequest() {
        this.json.setLength(0);
        this.json.append('[');
    }

    public void appendSeries(String namePrefix, String name, String nameSuffix, String[] columns, Object[][] points) {
        int i;
        if (this.json.length() > 1) {
            this.json.append(',');
        }
        this.json.append("{\"name\":\"").append(namePrefix).append(name).append(nameSuffix).append("\",\"columns\":[");
        for (i = 0; i < columns.length; ++i) {
            if (i > 0) {
                this.json.append(',');
            }
            this.json.append('\"').append(columns[i]).append('\"');
        }
        this.json.append("],\"points\":[");
        for (i = 0; i < points.length; ++i) {
            if (i > 0) {
                this.json.append(',');
            }
            Object[] row = points[i];
            this.json.append('[');
            for (int j = 0; j < row.length; ++j) {
                Object value;
                if (j > 0) {
                    this.json.append(',');
                }
                if ((value = row[j]) instanceof String) {
                    this.json.append('\"').append(value).append('\"');
                    continue;
                }
                this.json.append(value);
            }
            this.json.append(']');
        }
        this.json.append("]}");
    }

    public int sendRequest(boolean throwExc, boolean printJson) throws Exception {
        int lg = this.json.length();
        try {
            this.json.append(']');
            byte[] content = this.json.toString().getBytes(UTF_8);
            if (printJson || this.debugJson) {
                System.err.println("----");
                System.err.println(this.json);
                System.err.println("----");
            }
            HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            OutputStream wr = con.getOutputStream();
            wr.write(content);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                con.getInputStream().close();
                this.resetRequest();
            } else if (throwExc) {
                throw new IOException("Server returned HTTP response code: " + responseCode + "for URL: " + this.url + " with content :'" + con.getResponseMessage() + "'");
            }
            return responseCode;
        }
        catch (Exception exc) {
            this.json.setLength(lg);
            throw exc;
        }
    }
}

