package com.datalogic.device.input;

/**
 * @hide
 * Class containing utility action key IDs. These IDs are system defined and
 * cannot be re-defined by the user.
 */
public final class ActionKey {
    /**
     * ID of the action that changes the current layout to layout 1.
     */
    public static final int FN1 = 1;
    /**
    * ID of the action that changes the current layout to layout 2.
     */
    public static final int FN2 = 2;
    /**
    * ID of the action that changes the current layout to layout 3.
     */
    public static final int FN3 = 3;
    /**
    * ID of the action that changes the current layout to layout 4.
     */
    public static final int FN4 = 4;
    /**
    * ID of the action that changes the current layout to layout 5.
     */
    public static final int FN5 = 5;
    /**
    * ID of the action that changes the current layout to layout 6.
     */
    public static final int FN6 = 6;
    /**
    * ID of the action that changes the current layout to layout 7.
     */
    public static final int FN7 = 7;
    /**
    * ID of the action that changes the current layout to layout 8.
     */
    public static final int FN8 = 8;

    /**
     * ID of the action that enabled the keyboard backlight control.
     */
    public static final int KEYBOARD_BACKLIGHT_ON = 9;
    /**
     * ID of the action that disables the keyboard backlight control.
     */
    public static final int KEYBOARD_BACKLIGHT_OFF = 10;
    /**
     * ID of the action that increases the keyboard backlight brightness..
     */
    public static final int KEYBOARD_BACKLIGHT_UP = 11;
    /**
     * ID of the action that decreases the keyboard backlight brightness..
     */
    public static final int KEYBOARD_BACKLIGHT_DOWN = 12;
}
