package com.datalogic.decode;

/**
 * <code>Symbology</code> is an enumeration class defining constants for different barcode types.
 * 
 * Symbology class can be used to enable or disable quickly a group of barcode symbologies.
 */
public enum Symbology {
	/**
	 * Code 39
	 */
	CODE39, //
	/**
	 * Discrete 2/5
	 */
	DISCRETE25, //
	/**
	 * Matrix 2/5
	 */
	MATRIX25, //
	/**
	 * Interleaved 2/5
	 */
	INTERLEAVED25, //
	/**
	 * Codabar
	 */
	CODABAR, //
	/**
	 * Code 93
	 */
	CODE93, //
	/**
	 * Code 128
	 */
	CODE128, //
	/**
	 * UPC-A
	 */
	UPCA, //
	/**
	 * UPC-E
	 */
	UPCE, //
	/**
	 * EAN-13
	 */
	EAN13, //
	/**
	 * EAN-8
	 */
	EAN8, //
	/**
	 * MSI
	 */
	MSI, //
	/**
	 * GS1 Databar-14
	 */
	GS1_14, //
	/**
	 * GS1 Databar Limited
	 */
	GS1_LIMIT, //
	/**
	 * GS1 Databar Expanded
	 */
	GS1_EXP, //
	/**
	 * PDF-417
	 */
	PDF417, //
	/**
	 * Data Matrix
	 */
	DATAMATRIX, //
	/**
	 * Maxicode
	 */
	MAXICODE, //
	/**
	 * MicroPDF417
	 */
	MICROPDF417, //
	/**
	 * QR Code
	 */
	QRCODE, //
	/**
	 * Aztec Code
	 */
	AZTEC, //
	/**
	 * Postal Planet
	 */
	POSTAL_PLANET, //
	/**
	 * Postal Postnet
	 */
	POSTAL_POSTNET, //
	/**
	 * Postal USPS 4-State
	 */
	POSTAL_4STATE, //
	/**
	 * Postal Royal Mail
	 */
	POSTAL_ROYALMAIL, //
	/**
	 * Postal Australian
	 */
	POSTAL_AUSTRALIAN, //
	/**
	 * Postal Kix
	 */
	POSTAL_KIX, //
	/**
	 * Postal Japan
	 */
	POSTAL_JAPAN, //
	/**
	 * Code 39 to Code 32 conversion
	 */
	CODE32, //
	/**
	 * Trioptic Code 39
	 */
	TRIOPTIC, //
	/**
	 * GS1-128
	 */
	GS1_128, //
	/**
	 * Micro QR Code
	 */
	MICRO_QR, //
	/**
	 * UPC/EAN 2 digits Extension
	 */
	EAN_EXT_2_DIGIT, //
	/**
	 * UPC/EAN 5 digits Extension
	 */
	EAN_EXT_5_DIGIT, //
	/**
	 * Digimarc barcode &#8482;
	 */
	DIGIMARC, //
	/**
	 * GS1 Composite
	 */
	COMPOSITE, //
	/**
	 * DotCode
	 */
	DOTCODE, //
	/**
	 * ISBT 128
	 */
	ISBT_128, //
	/**
	 * ISBT 128 Concatenated
	 */
	ISBT_128_CONCATENATED; //
}
