package com.datalogic.device.info;

/**
 * The <code>WiFiType</code> enumeration lists Wi-Fi types.
 */
public enum WiFiType {
	/**
	 * No Wi-Fi chip has been detected
	 */
	NONE, //
	/**
	 * Wi-Fi supports b/g
	 */
	BG, //
	/**
	 * Wi-Fi supports a/b/g
	 */
	ABG, //
	/**
	 * Wi-Fi supports a/b/g/n
	 */
	ABGN, //
	/**
	 * Wi-Fi supports b/g/n
	 */
	BGN; //
}
