/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.dataset.builder;

import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.dataset.builder.BasicRowBuilder;
import com.github.database.rider.core.dataset.builder.BuilderUtil;
import com.github.database.rider.core.dataset.builder.ColumnBuilder;
import com.github.database.rider.core.dataset.builder.DataSetBuilder;
import com.github.database.rider.core.dataset.builder.RowBuilder;
import javax.persistence.metamodel.Attribute;
import org.dbunit.dataset.IDataSet;

public class TableBuilder {
    private final DataSetBuilder dataSetBuilder;
    private RowBuilder currentRowBuilder;
    private ColumnBuilder currentColumnBuilder;
    private String tableName;

    public TableBuilder(DataSetBuilder dataSetBuilder, String tableName, DBUnitConfig config) {
        this.currentRowBuilder = new RowBuilder(this, tableName, config);
        this.dataSetBuilder = dataSetBuilder;
        this.tableName = tableName;
    }

    public RowBuilder row() {
        if (this.currentRowBuilder.hasColumns()) {
            this.saveCurrentRow();
            this.currentRowBuilder.setAdded(false);
            this.currentRowBuilder.getColumnsValues().clear();
        }
        return this.currentRowBuilder;
    }

    public ColumnBuilder columns(String ... columns) {
        if (this.currentColumnBuilder != null && this.currentColumnBuilder.hasColumns()) {
            this.saveCurrentRow(this.currentColumnBuilder);
            this.currentColumnBuilder.getColumnsValues().clear();
        }
        this.currentColumnBuilder = new ColumnBuilder(this, this.tableName, this.currentRowBuilder.config, columns);
        return this.currentColumnBuilder;
    }

    public ColumnBuilder columns(Attribute ... columns) {
        String[] columnList = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnList[i] = BuilderUtil.getColumnNameFromMetaModel(columns[i]);
        }
        return this.columns(columnList);
    }

    protected RowBuilder getCurrentRowBuilder() {
        return this.currentRowBuilder;
    }

    protected DataSetBuilder getDataSetBuilder() {
        return this.dataSetBuilder;
    }

    protected void saveCurrentRow() {
        if (!this.currentRowBuilder.isAdded()) {
            this.currentRowBuilder.setAdded(true);
            this.dataSetBuilder.add(this.currentRowBuilder);
        }
    }

    protected void saveCurrentRow(BasicRowBuilder rowBuilder) {
        rowBuilder.setAdded(true);
        this.dataSetBuilder.add(rowBuilder);
    }

    public TableBuilder defaultValue(String columnName, Object value) {
        this.dataSetBuilder.addTableDefaultValue(this.tableName, columnName, value);
        return this;
    }

    public TableBuilder table(String table) {
        this.saveCurrentRow();
        return this.dataSetBuilder.table(table);
    }

    public IDataSet build() {
        this.saveCurrentRow();
        return this.dataSetBuilder.build();
    }
}

