/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.api.exporter;

import com.github.database.rider.core.api.dataset.DataSetFormat;
import com.github.database.rider.core.api.exporter.BuilderType;
import com.github.database.rider.core.api.exporter.ExportDataSet;

public class DataSetExportConfig {
    private DataSetFormat dataSetFormat = DataSetFormat.YML;
    private String[] includeTables;
    private String[] queryList;
    private boolean dependentTables = true;
    private String outputFileName;
    private BuilderType builderType = BuilderType.NONE;

    public DataSetExportConfig dataSetFormat(DataSetFormat dataSetFormat) {
        this.dataSetFormat = dataSetFormat;
        return this;
    }

    public DataSetExportConfig includeTables(String[] includeTables) {
        this.includeTables = includeTables;
        return this;
    }

    public DataSetExportConfig dependentTables(boolean dependentTables) {
        this.dependentTables = dependentTables;
        return this;
    }

    public DataSetExportConfig queryList(String[] queryList) {
        this.queryList = queryList;
        return this;
    }

    public DataSetExportConfig outputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
        return this;
    }

    public DataSetExportConfig builderType(BuilderType builderType) {
        this.builderType = builderType;
        return this;
    }

    public DataSetFormat getDataSetFormat() {
        return this.dataSetFormat;
    }

    public String[] getIncludeTables() {
        return this.includeTables;
    }

    public boolean isDependentTables() {
        return this.dependentTables;
    }

    public String[] getQueryList() {
        return this.queryList;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public BuilderType getBuilderType() {
        return this.builderType;
    }

    public static DataSetExportConfig from(ExportDataSet dataSetExport) {
        return new DataSetExportConfig().dataSetFormat(dataSetExport.format()).dependentTables(dataSetExport.dependentTables()).outputFileName(dataSetExport.outputName()).builderType(dataSetExport.builderType()).includeTables(dataSetExport.includeTables()).queryList(dataSetExport.queryList());
    }
}

