/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.api.dataset;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.database.rider.core.api.dataset.MapDataSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.dbunit.dataset.ITable;

public class JSONDataSet
extends MapDataSet {
    private final JSONITableParser jsonTableParser = new JSONITableParser();
    private final ObjectMapper mapper = new ObjectMapper();

    public JSONDataSet(File file) {
        this.tables = this.jsonTableParser.getTables(file);
    }

    public JSONDataSet(InputStream is) {
        this.tables = this.jsonTableParser.getTables(is);
    }

    private class JSONITableParser {
        private JSONITableParser() {
        }

        public List<ITable> getTables(File jsonFile) {
            try {
                return this.getTables(new FileInputStream(jsonFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public List<ITable> getTables(InputStream jsonStream) {
            try {
                Map dataset = (Map)JSONDataSet.this.mapper.readValue(jsonStream, Map.class);
                dataset.remove("$schema");
                return JSONDataSet.this.mapTableParser.getTables(dataset);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

