/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.util;

import java.util.HashMap;
import java.util.Map;

public class PropertyResolutionUtil {
    private static final String PROP_FILTER = "^jakarta.persistence.(.*)|^eclipselink.(.*)|^hibernate.(.*)|^openjpa.(.)*";

    public Map<String, Object> getSystemJavaxPersistenceOverrides() {
        if (this.propertyOverridesExist()) {
            return this.mergeFilteredMaps(this.castMap(System.getenv()), System.getProperties());
        }
        return null;
    }

    Map<String, Object> castMap(Map<String, String> stringStringMap) {
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : stringStringMap.entrySet()) {
            stringObjectMap.put(entry.getKey(), entry.getValue());
        }
        return stringObjectMap;
    }

    public Map<String, Object> persistencePropertiesOverrides(Map<String, Object> overridingProperties) {
        if (overridingProperties == null) {
            throw new IllegalArgumentException("the property 'overridingProperties' is not allowed to be null.");
        }
        HashMap<String, Object> overridingProperttiesCopy = new HashMap<String, Object>(overridingProperties);
        return this.mergeFilteredMaps(this.getSystemJavaxPersistenceOverrides(), overridingProperttiesCopy);
    }

    boolean propertyOverridesExist() {
        return System.getProperties().containsKey("jakarta.persistence.jdbc.url") || System.getProperties().containsKey("jakarta.persistence.jdbc.user") || System.getProperties().containsKey("jakarta.persistence.jdbc.password") || System.getProperties().containsKey("jakarta.persistence.jdbc.driver") || System.getenv().containsKey("jakarta.persistence.jdbc.url") || System.getenv().containsKey("jakarta.persistence.jdbc.user") || System.getenv().containsKey("jakarta.persistence.jdbc.password") || System.getenv().containsKey("jakarta.persistence.jdbc.driver");
    }

    Map<String, Object> mergeFilteredMaps(Map<String, Object> ... enlistedMaps) {
        HashMap<String, Object> targetMap = new HashMap<String, Object>();
        for (Map<String, Object> map : enlistedMaps) {
            if (map == null) continue;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (!entry.getKey().matches(PROP_FILTER)) continue;
                targetMap.put(entry.getKey(), entry.getValue());
            }
        }
        return targetMap.size() > 0 ? targetMap : null;
    }
}

