/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.util;

import com.github.database.rider.core.util.ClassUtils;
import com.github.database.rider.core.util.PropertyResolutionUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Persistence;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerProvider
implements TestRule {
    private static Map<String, EntityManagerProvider> providers = new ConcurrentHashMap<String, EntityManagerProvider>();
    private EntityManagerFactory emf;
    private EntityManager em;
    private EntityTransaction tx;
    private Connection conn;
    private static PropertyResolutionUtil propertyResolutionUtil = new PropertyResolutionUtil();
    private static EntityManagerProvider instance;
    private static Logger log;

    protected EntityManagerProvider() {
    }

    public static synchronized EntityManagerProvider instance(String unitName) {
        return EntityManagerProvider.instance(unitName, new HashMap<String, Object>());
    }

    @Deprecated
    public static synchronized EntityManagerProvider instance(String unitName, Map<String, Object> overridingPersistenceProps) {
        instance = providers.get(unitName);
        if (instance == null) {
            instance = new EntityManagerProvider();
            providers.put(unitName, instance);
        }
        try {
            instance.init(unitName, overridingPersistenceProps);
        }
        catch (Exception e) {
            log.error("Could not initialize persistence unit " + unitName, (Throwable)e);
        }
        return instance;
    }

    public static void removeInstance(String unitName) {
        providers.remove(unitName);
    }

    public static synchronized EntityManagerProvider newInstance(String unitName, Map<String, Object> overridingPersistenceProps) {
        instance = new EntityManagerProvider();
        providers.put(unitName, instance);
        try {
            instance.init(unitName, overridingPersistenceProps);
        }
        catch (Exception e) {
            log.error("Could not initialize persistence unit " + unitName, (Throwable)e);
        }
        return instance;
    }

    public static synchronized EntityManagerProvider newInstance(String unitName) {
        return EntityManagerProvider.newInstance(unitName, new HashMap<String, Object>());
    }

    private void init(String unitName, Map<String, Object> props) throws SQLException {
        if (this.emf == null) {
            log.debug("creating emf for unit {}", (Object)unitName);
            Map<String, Object> dbConfig = propertyResolutionUtil.persistencePropertiesOverrides(props);
            log.debug("using dbConfig '{}' to create emf", dbConfig);
            this.emf = dbConfig == null ? Persistence.createEntityManagerFactory((String)unitName) : Persistence.createEntityManagerFactory((String)unitName, dbConfig);
            this.em = this.emf.createEntityManager();
            this.conn = this.createConnection(this.em);
            this.tx = this.em.getTransaction();
        }
        this.emf.getCache().evictAll();
    }

    private Connection createConnection(EntityManager em) throws SQLException {
        Connection connection;
        EntityTransaction tx = em.getTransaction();
        if (this.isHibernateOnClasspath() && em.getDelegate() instanceof Session) {
            connection = ((SessionImplementor)em.unwrap(SessionImplementor.class)).getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
        } else {
            tx.begin();
            connection = (Connection)em.unwrap(Connection.class);
            tx.commit();
        }
        return connection;
    }

    public Connection connection(String puName) {
        return EntityManagerProvider.instance((String)puName).conn;
    }

    public Connection connection() {
        EntityManagerProvider.checkInstance();
        try {
            if (EntityManagerProvider.instance.conn == null || EntityManagerProvider.instance.conn.isClosed()) {
                EntityManagerProvider.instance.conn = this.createConnection(EntityManagerProvider.instance.em);
            }
        }
        catch (SQLException e) {
            log.error("Could not create new jdbc connection.", (Throwable)e);
        }
        return EntityManagerProvider.instance.conn;
    }

    public static EntityManager em(String puName) {
        return EntityManagerProvider.instance((String)puName).em;
    }

    public static EntityManagerFactory emf(String puName) {
        return EntityManagerProvider.instance((String)puName).emf;
    }

    public static EntityManager em() {
        EntityManagerProvider.checkInstance();
        return EntityManagerProvider.instance.em;
    }

    public EntityManager getEm() {
        return EntityManagerProvider.em();
    }

    public static EntityManagerFactory emf() {
        return EntityManagerProvider.instance.emf;
    }

    public EntityManagerFactory getEmf() {
        return EntityManagerProvider.instance.emf;
    }

    public EntityManager getEm(String puName) {
        return EntityManagerProvider.em(puName);
    }

    public static EntityManagerProvider clear(String puName) {
        EntityManagerProvider.em(puName).clear();
        EntityManagerProvider.emf(puName).getCache().evictAll();
        return providers.get(puName);
    }

    public static EntityManagerProvider clear() {
        if (EntityManagerProvider.isEntityManagerActive()) {
            EntityManagerProvider.em().clear();
            EntityManagerProvider.emf().getCache().evictAll();
            return instance;
        }
        return null;
    }

    public static EntityTransaction tx(String puName) {
        return EntityManagerProvider.em(puName).getTransaction();
    }

    public static EntityTransaction tx() {
        EntityManagerProvider.checkInstance();
        if (EntityManagerProvider.instance.tx == null) {
            EntityManagerProvider.instance.tx = EntityManagerProvider.instance.em.getTransaction();
        }
        return EntityManagerProvider.instance.tx;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    instance.em.clear();
                }
            }
        };
    }

    private boolean isHibernateOnClasspath() {
        return ClassUtils.isOnClasspath("org.hibernate.Session");
    }

    private static void checkInstance() {
        if (instance == null) {
            throw new IllegalStateException("Call instance('PU_NAME') before calling em()");
        }
    }

    public static boolean isEntityManagerActive() {
        return instance != null && EntityManagerProvider.em().isOpen();
    }

    static {
        log = LoggerFactory.getLogger(EntityManagerProvider.class);
    }
}

