/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.dataset.builder;

import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.dataset.builder.BasicRowBuilder;
import com.github.database.rider.core.dataset.builder.BuilderUtil;
import com.github.database.rider.core.dataset.builder.ColumnSpec;
import com.github.database.rider.core.dataset.builder.TableBuilder;
import jakarta.persistence.metamodel.Attribute;
import java.util.Calendar;
import java.util.Date;
import org.dbunit.dataset.IDataSet;

public class RowBuilder
extends BasicRowBuilder {
    private final TableBuilder tableBuilder;

    protected RowBuilder(TableBuilder tableBuilder, String tableName, DBUnitConfig config) {
        super(tableName, config);
        this.tableBuilder = tableBuilder;
    }

    public RowBuilder column(ColumnSpec column, Object value) {
        super.column(column.name(), value);
        return this;
    }

    public RowBuilder column(String columnName, Date value) {
        this.put(columnName, this.formatDateValue(value));
        return this;
    }

    public RowBuilder column(String columnName, Calendar value) {
        this.put(columnName, this.formatDateValue(value));
        return this;
    }

    public RowBuilder column(Attribute column, Object value) {
        String columnName = BuilderUtil.getColumnNameFromMetaModel(column);
        super.column(columnName, value);
        return this;
    }

    @Override
    public RowBuilder column(String columnName, Object value) {
        super.column(columnName, value);
        return this;
    }

    public RowBuilder column(Attribute column, Calendar value) {
        String columnName = BuilderUtil.getColumnNameFromMetaModel(column);
        return this.column(columnName, value);
    }

    public RowBuilder column(Attribute column, Date value) {
        String columnName = BuilderUtil.getColumnNameFromMetaModel(column);
        return this.column(columnName, value);
    }

    public RowBuilder row() {
        return this.tableBuilder.row();
    }

    public TableBuilder table(String tableName) {
        this.tableBuilder.saveCurrentRow();
        return this.tableBuilder.getDataSetBuilder().table(tableName);
    }

    public IDataSet build() {
        return this.tableBuilder.getDataSetBuilder().build();
    }
}

