/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.assertion;

import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.operators.OperatorSet;
import it.unibo.tuprolog.core.parsing.TermParser;
import it.unibo.tuprolog.solve.Solution;
import it.unibo.tuprolog.solve.SolveOptions;
import it.unibo.tuprolog.solve.Solver;
import it.unibo.tuprolog.solve.classic.ClassicSolverFactory;
import it.unibo.tuprolog.theory.Theory;
import it.unibo.tuprolog.theory.parsing.ClausesReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.dbunit.DatabaseUnitException;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrologAssert {
    private static final Logger log = LoggerFactory.getLogger(PrologAssert.class);

    public static void compareProlog(IDataSet current, IDataSet expected, String[] tableNames, Long prologTimeout) throws DatabaseUnitException {
        StringBuilder sbDatabaseFacts = new StringBuilder();
        ArrayList<String> queryTerms = new ArrayList<String>();
        for (String tableName : tableNames) {
            ITable expectedTable = expected.getTable(tableName);
            ITable actualTable = current.getTable(tableName);
            sbDatabaseFacts.append(PrologAssert.createActualTableFacts(actualTable));
            queryTerms.addAll(PrologAssert.createQueryTermsFromExpectedTable(expectedTable, actualTable));
        }
        String databaseFacts = sbDatabaseFacts.toString();
        String databaseQuery = String.join((CharSequence)",", queryTerms);
        PrologAssert.solve(prologTimeout, databaseFacts, databaseQuery);
    }

    private static String createActualTableFacts(ITable actualTable) throws DataSetException {
        StringBuilder sbTableFacts = new StringBuilder();
        int i = 0;
        while (i < actualTable.getRowCount()) {
            sbTableFacts.append(PrologAssert.tableToRelationName(actualTable));
            sbTableFacts.append("(");
            int finalI = i++;
            sbTableFacts.append(Arrays.stream(actualTable.getTableMetaData().getColumns()).map(column -> {
                try {
                    return actualTable.getValue(finalI, column.getColumnName());
                }
                catch (DataSetException e) {
                    throw new RuntimeException(e);
                }
            }).map(o -> PrologAssert.wrap(PrologAssert.escape(o))).collect(Collectors.joining(",")));
            sbTableFacts.append(").\n");
        }
        return sbTableFacts.toString();
    }

    private static List<String> createQueryTermsFromExpectedTable(ITable expectedTable, ITable actualTable) throws DataSetException {
        ArrayList<String> queryTerms = new ArrayList<String>();
        int i = 0;
        while (i < expectedTable.getRowCount()) {
            StringBuilder sbQuery = new StringBuilder();
            sbQuery.append(PrologAssert.tableToRelationName(expectedTable));
            sbQuery.append("(");
            int finalI = i++;
            sbQuery.append(Arrays.stream(actualTable.getTableMetaData().getColumns()).map(column -> {
                try {
                    return expectedTable.getValue(finalI, column.getColumnName());
                }
                catch (DataSetException e) {
                    return null;
                }
            }).map(o -> o == null ? "_" : (o.toString().startsWith("$$") && o.toString().endsWith("$$") ? o.toString().replaceAll("\\$\\$", "").toUpperCase() : PrologAssert.wrap(PrologAssert.escape(o)))).collect(Collectors.joining(",")));
            sbQuery.append(")");
            queryTerms.add(sbQuery.toString());
        }
        return queryTerms;
    }

    private static String tableToRelationName(ITable expectedTable) {
        return expectedTable.getTableMetaData().getTableName().toLowerCase();
    }

    private static void solve(Long prologTimeout, String databaseFacts, String databaseQuery) throws DataSetException {
        log.debug("Attempting to solve, facts = {}, query = {}", (Object)databaseFacts, (Object)databaseQuery);
        ClausesReader theoryReader = ClausesReader.withDefaultOperators();
        ClassicSolverFactory solverFactory = ClassicSolverFactory.INSTANCE;
        ByteArrayInputStream bais = new ByteArrayInputStream(databaseFacts.getBytes(StandardCharsets.UTF_8));
        Theory theory = theoryReader.readTheory((InputStream)bais);
        Solver solver = solverFactory.solverWithDefaultBuiltins(theory);
        TermParser termParser = TermParser.withOperators((OperatorSet)solver.getOperators());
        Struct query = termParser.parseStruct(databaseQuery);
        Iterator si = solver.solve(query, SolveOptions.allLazilyWithTimeout((long)prologTimeout)).iterator();
        if (!si.hasNext() || ((Solution)si.next()).isNo()) {
            throw new DataSetException("Could not find a solution to theory: " + theory + " given query: " + query);
        }
    }

    private static String wrap(Object o) {
        return "'" + o + "'";
    }

    private static String escape(Object o) {
        if (o == null) {
            return "[null]";
        }
        return o.toString().replaceAll("'", "''");
    }
}

