/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.leak;

import com.github.database.rider.core.api.leak.LeakHunter;
import com.github.database.rider.core.leak.LeakHunterException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.LoggerFactory;

public abstract class AbstractLeakHunter
implements LeakHunter {
    protected final Connection connection;
    private final String methodName;
    private final boolean cacheConnection;
    private Integer openConnectionsBeforeExecution;

    public AbstractLeakHunter(Connection connection, String methodName, boolean cacheConnection) {
        this.methodName = methodName;
        this.cacheConnection = cacheConnection;
        this.connection = connection;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int openConnections() {
        try (Statement statement = this.connection.createStatement();){
            int n;
            block18: {
                ResultSet resultSet;
                block16: {
                    int n2;
                    block17: {
                        resultSet = statement.executeQuery(this.leakCountSql());
                        try {
                            if (!resultSet.next()) break block16;
                            n2 = resultSet.getInt(1);
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return n2;
                }
                n = 0;
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int measureConnectionsBeforeExecution() {
        this.openConnectionsBeforeExecution = this.openConnections();
        return this.openConnectionsBeforeExecution;
    }

    @Override
    public void checkConnectionsAfterExecution() throws LeakHunterException {
        if (this.openConnectionsBeforeExecution == null) {
            throw new IllegalStateException("unknown number of opened connections before execution");
        }
        int openConnectionsAfterExecution = this.openConnections();
        try {
            if (!this.cacheConnection && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LoggerFactory.getLogger((String)this.getClass().getName()).error("Could not close leak hunter connection", (Throwable)e);
        }
        if (openConnectionsAfterExecution > this.openConnectionsBeforeExecution) {
            throw new LeakHunterException(this.methodName, openConnectionsAfterExecution - this.openConnectionsBeforeExecution);
        }
    }

    protected abstract String leakCountSql();
}

