/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.exporter.builder;

import com.github.database.rider.core.api.exporter.BuilderType;
import com.github.database.rider.core.exporter.builder.BuilderExportConfig;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetBuilderExporter {
    private final Logger LOGGER = LoggerFactory.getLogger(DataSetBuilderExporter.class);
    private final String NEW_LINE = System.getProperty("line.separator");
    private final String FOUR_SPACES = "    ";

    public void export(IDataSet dataset, BuilderExportConfig config) {
        try {
            CachedDataSet builderDataSet = new CachedDataSet(dataset);
            StringBuilder source = new StringBuilder("DataSetBuilder builder = new DataSetBuilder();").append(this.NEW_LINE).append("IDataSet dataSet = builder");
            boolean defaultSyntax = BuilderType.DEFAULT == config.getType();
            ITableIterator datasetIterator = builderDataSet.iterator();
            while (datasetIterator.next()) {
                ITable table = datasetIterator.getTable();
                source.append(this.NEW_LINE + "    " + ".table(\"").append(table.getTableMetaData().getTableName()).append("\")");
                if (!defaultSyntax) {
                    this.generateBuilderUsingColumnsValuesSyntax(table, source);
                    continue;
                }
                this.generateBuilderUsingDefaultSyntax(table, source);
            }
            source.append(".build();");
            try (FileOutputStream fout = new FileOutputStream(config.getOutputDir());){
                fout.write(source.toString().getBytes(StandardCharsets.UTF_8));
                this.LOGGER.info("DataSetBuilder exported successfully at " + config.getOutputDir().getAbsolutePath());
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Could not generate DataSetBuilder for given dataset.", (Throwable)e);
        }
    }

    protected void generateBuilderUsingDefaultSyntax(ITable table, StringBuilder source) throws DataSetException {
        ITableMetaData tableMetaData = table.getTableMetaData();
        if (table.getRowCount() > 0) {
            source.append(this.NEW_LINE);
        }
        for (int i = 0; i < table.getRowCount(); ++i) {
            boolean isLastRow = i == table.getRowCount() - 1;
            source.append("    ").append(".row()").append(this.NEW_LINE);
            for (int j = 0; j < tableMetaData.getColumns().length; ++j) {
                boolean isLastColumn = j == tableMetaData.getColumns().length - 1;
                Column column = tableMetaData.getColumns()[j];
                source.append("        ").append(".column(\"").append(column.getColumnName()).append("\", ");
                Object value = table.getValue(i, tableMetaData.getColumns()[j].getColumnName());
                this.appendColumnValue(source, column, value);
                source.append(")");
                if (isLastColumn && isLastRow) continue;
                source.append(this.NEW_LINE);
            }
        }
    }

    private void appendColumnValue(StringBuilder source, Column column, Object value) {
        boolean isNumeric = column.getDataType().isNumber();
        if (!isNumeric) {
            source.append("\"");
        }
        source.append(value);
        if (!isNumeric) {
            source.append("\"");
        }
    }

    protected void generateBuilderUsingColumnsValuesSyntax(ITable table, StringBuilder source) throws DataSetException {
        if (table.getRowCount() == 0) {
            return;
        }
        source.append(this.NEW_LINE);
        ITableMetaData tableMetaData = table.getTableMetaData();
        source.append("        ").append(".columns(");
        for (Column column : tableMetaData.getColumns()) {
            source.append("\"" + column.getColumnName()).append("\", ");
        }
        if (source.indexOf(",") != -1) {
            int indexOfComma = source.lastIndexOf(",");
            source.deleteCharAt(indexOfComma);
            source.deleteCharAt(indexOfComma);
        }
        source.append(")").append(this.NEW_LINE + "    ");
        for (int i = 0; i < table.getRowCount(); ++i) {
            boolean isLastRow = i == table.getRowCount() - 1;
            source.append("    .values(");
            for (int j = 0; j < tableMetaData.getColumns().length; ++j) {
                boolean lastColumn = j == tableMetaData.getColumns().length - 1;
                Column column = tableMetaData.getColumns()[j];
                Object value = table.getValue(i, tableMetaData.getColumns()[j].getColumnName());
                this.appendColumnValue(source, column, value);
                if (!lastColumn) {
                    source.append(", ");
                    continue;
                }
                source.append(",");
            }
            source.deleteCharAt(source.lastIndexOf(","));
            source.append(")");
            if (isLastRow) continue;
            source.append(this.NEW_LINE + "    ");
        }
    }
}

