/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.configuration;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;

public class SnakeYamlHelper {
    public static Yaml createYaml() {
        LoaderOptions loaderOptions = SnakeYamlHelper.createLoaderOptions();
        return new Yaml(loaderOptions);
    }

    private static LoaderOptions createLoaderOptions() {
        LoaderOptions loaderOptions = new LoaderOptions();
        try {
            Class<?> tagInspectorClass = Class.forName("org.yaml.snakeyaml.inspector.TagInspector");
            Method setTagInspector = loaderOptions.getClass().getMethod("setTagInspector", tagInspectorClass);
            Object isGlobalTagAllowedLambda = SnakeYamlHelper.createIsGlobalTagAllowedLambda(tagInspectorClass);
            setTagInspector.invoke((Object)loaderOptions, isGlobalTagAllowedLambda);
        }
        catch (ClassNotFoundException tagInspectorClass) {
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to create SnakeYaml LoaderOptions", e);
        }
        return loaderOptions;
    }

    private static Object createIsGlobalTagAllowedLambda(Class<?> tagInspectorClass) throws Throwable {
        MethodType methodType = MethodType.methodType(Boolean.TYPE, Tag.class);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle handle = lookup.findStatic(SnakeYamlHelper.class, "isGlobalTagAllowed", methodType);
        CallSite callSite = LambdaMetafactory.metafactory(lookup, "isGlobalTagAllowed", MethodType.methodType(tagInspectorClass), methodType, handle, methodType);
        MethodHandle target = callSite.getTarget();
        return target.invoke();
    }

    private static boolean isGlobalTagAllowed(Tag tag) {
        return true;
    }
}

