/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.configuration;

import com.github.database.rider.core.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;

final class DBUnitConfigPropertyResolver {
    private static final String DBUNIT_PROPERTY_EL_REGEX = "\\$\\{(.*)}";
    private static final String DBUNIT_PROPERTY_EL_IDENTIFIER = "${";

    private DBUnitConfigPropertyResolver() {
    }

    static <T> T resolveProperty(T originalValue) {
        String propertyName;
        String value;
        if (originalValue != null && originalValue.toString().startsWith(DBUNIT_PROPERTY_EL_IDENTIFIER) && (value = ObjectUtils.defaultIfNull(System.getProperty(propertyName = originalValue.toString().replaceAll(DBUNIT_PROPERTY_EL_REGEX, "$1")), System.getenv(propertyName))) != null) {
            return (T)value;
        }
        return originalValue;
    }

    static Map<String, Object> resolveProperties(Map<String, Object> originalProperties) {
        HashMap<String, Object> resolvedProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : originalProperties.entrySet()) {
            resolvedProperties.put(entry.getKey(), DBUnitConfigPropertyResolver.resolveProperty(entry.getValue()));
        }
        return resolvedProperties;
    }
}

