/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.api.dataset;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DefaultTable;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;

public class MapDataSet
extends AbstractDataSet {
    protected MapITableParser mapTableParser = new MapITableParser();
    protected List<ITable> tables;

    protected MapDataSet() {
    }

    public MapDataSet(Map<String, Object> dataset) {
        this.tables = this.mapTableParser.getTables(dataset);
    }

    protected ITableIterator createIterator(boolean reverse) {
        return new DefaultTableIterator(this.tables.toArray(new ITable[this.tables.size()]));
    }

    protected static class MapITableParser {
        protected MapITableParser() {
        }

        protected List<ITable> getTables(Map<String, Object> dataset) {
            ArrayList<ITable> tables = new ArrayList<ITable>();
            for (Map.Entry<String, Object> entry : dataset.entrySet()) {
                List rows = (List)entry.getValue();
                ITableMetaData meta = this.getMetaData(entry.getKey(), rows);
                DefaultTable table = new DefaultTable(meta);
                int rowIndex = 0;
                for (Map row : rows) {
                    this.fillRow(table, row, rowIndex++);
                }
                tables.add((ITable)table);
            }
            return tables;
        }

        private ITableMetaData getMetaData(String tableName, List<Map<String, Object>> rows) {
            LinkedHashSet<String> columns = new LinkedHashSet<String>();
            for (Map<String, Object> row : rows) {
                for (Map.Entry<String, Object> column : row.entrySet()) {
                    columns.add(column.getKey());
                }
            }
            ArrayList<Column> list = new ArrayList<Column>(columns.size());
            for (String s : columns) {
                list.add(new Column(s, DataType.UNKNOWN));
            }
            return new DefaultTableMetaData(tableName, list.toArray(new Column[list.size()]));
        }

        private void fillRow(DefaultTable table, Map<String, Object> row, int rowIndex) {
            try {
                if (!row.entrySet().isEmpty()) {
                    table.addRow();
                    for (Map.Entry<String, Object> column : row.entrySet()) {
                        table.setValue(rowIndex, column.getKey(), column.getValue());
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

