/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.util;

import com.github.database.rider.core.api.dataset.DataSet;
import com.github.database.rider.core.api.dataset.DataSetImpl;
import com.github.database.rider.core.replacers.Replacer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.runner.Description;

public final class AnnotationUtils {
    private static final Map<AnnotationCacheKey, Annotation> annotationCache = new ConcurrentHashMap<AnnotationCacheKey, Annotation>(256);

    private AnnotationUtils() {
    }

    public static boolean isAnnotated(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotation(element, annotationType) != null;
    }

    public static <A extends Annotation> A findAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(element, annotationType, new HashSet<Annotation>());
    }

    private static <A extends Annotation> A findAnnotation(AnnotatedElement element, Class<A> annotationType, Set<Annotation> visited) {
        if (annotationType == null) {
            throw new RuntimeException("annotationType must not be null");
        }
        if (element == null) {
            return null;
        }
        AnnotationCacheKey key = new AnnotationCacheKey(element, annotationType);
        Annotation annotation = annotationCache.get(key);
        if (annotation != null) {
            return (A)annotation;
        }
        annotation = AnnotationUtils.getDeclaredAnnotation(element, annotationType);
        if (annotation != null) {
            annotationCache.put(key, annotation);
            return (A)annotation;
        }
        A directMetaAnnotation = AnnotationUtils.findMetaAnnotation(annotationType, element.getDeclaredAnnotations(), key, visited);
        if (directMetaAnnotation != null) {
            return directMetaAnnotation;
        }
        if (element instanceof Class) {
            Class clazz = (Class)element;
            for (Class<?> ifc : clazz.getInterfaces()) {
                A annotationOnInterface;
                if (ifc == Annotation.class || (annotationOnInterface = AnnotationUtils.findAnnotation(ifc, annotationType, visited)) == null) continue;
                return annotationOnInterface;
            }
        }
        if ((annotation = element.getAnnotation(annotationType)) != null) {
            annotationCache.put(key, annotation);
            return (A)annotation;
        }
        return AnnotationUtils.findMetaAnnotation(annotationType, element.getAnnotations(), key, visited);
    }

    private static <A extends Annotation> A getDeclaredAnnotation(AnnotatedElement element, Class<A> annotationType) {
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (A)annotation;
        }
        return null;
    }

    private static <A extends Annotation> A findMetaAnnotation(Class<A> annotationType, Annotation[] candidates, AnnotationCacheKey key, Set<Annotation> visited) {
        for (Annotation candidateAnnotation : candidates) {
            A metaAnnotation;
            Class<? extends Annotation> candidateAnnotationType = candidateAnnotation.annotationType();
            if (AnnotationUtils.isInJavaLangAnnotationPackage(candidateAnnotationType) || !visited.add(candidateAnnotation) || (metaAnnotation = AnnotationUtils.findAnnotation(candidateAnnotationType, annotationType, visited)) == null) continue;
            annotationCache.put(key, (Annotation)metaAnnotation);
            return metaAnnotation;
        }
        return null;
    }

    private static boolean isInJavaLangAnnotationPackage(Class<? extends Annotation> annotationType) {
        return annotationType != null && annotationType.getName().startsWith("java.lang.annotation");
    }

    public static <A extends Annotation> A findAnnotation(Description description, Class<A> class1) {
        try {
            Method method = description.getTestClass().getMethod(description.getMethodName(), new Class[0]);
            return AnnotationUtils.findAnnotation(method, class1);
        }
        catch (NoSuchMethodException | NullPointerException | SecurityException e) {
            Annotation annotation = description.getAnnotation(class1);
            if (annotation == null) {
                annotation = description.getTestClass().getAnnotation(class1);
            }
            return (A)annotation;
        }
    }

    public static DataSet mergeDataSetAnnotations(DataSet classLevelDataSet, DataSet methodLevelDataSet) {
        String[] value = AnnotationUtils.joinArray(classLevelDataSet.value(), methodLevelDataSet.value());
        String[] tableOrdering = AnnotationUtils.joinArray(classLevelDataSet.tableOrdering(), methodLevelDataSet.tableOrdering());
        String[] executeStatementsBefore = AnnotationUtils.joinArray(classLevelDataSet.executeStatementsBefore(), methodLevelDataSet.executeStatementsBefore());
        String[] executeStatementsAfter = AnnotationUtils.joinArray(classLevelDataSet.executeStatementsAfter(), methodLevelDataSet.executeStatementsAfter());
        String[] executeScriptsAfter = AnnotationUtils.joinArray(classLevelDataSet.executeScriptsAfter(), methodLevelDataSet.executeScriptsAfter());
        String[] executeScriptsBefore = AnnotationUtils.joinArray(classLevelDataSet.executeScriptsBefore(), methodLevelDataSet.executeScriptsBefore());
        String[] skipCleaningFor = AnnotationUtils.joinArray(classLevelDataSet.skipCleaningFor(), methodLevelDataSet.skipCleaningFor());
        Class<? extends Replacer>[] replacers = AnnotationUtils.joinReplacers(classLevelDataSet.replacers(), methodLevelDataSet.replacers());
        DataSetImpl mergedDataSet = new DataSetImpl(value, methodLevelDataSet.executorId(), methodLevelDataSet.strategy(), methodLevelDataSet.useSequenceFiltering(), tableOrdering, methodLevelDataSet.disableConstraints(), methodLevelDataSet.fillIdentityColumns(), executeStatementsBefore, executeScriptsAfter, executeScriptsBefore, executeStatementsAfter, methodLevelDataSet.cleanBefore(), methodLevelDataSet.cleanAfter(), methodLevelDataSet.transactional(), skipCleaningFor, replacers);
        return mergedDataSet;
    }

    private static String[] joinArray(String[] ... arrays) {
        int length = 0;
        for (String[] array : arrays) {
            if (!AnnotationUtils.isNotEmptyArray(array)) continue;
            length += array.length;
        }
        String[] result = new String[length];
        int offset = 0;
        for (String[] array : arrays) {
            if (!AnnotationUtils.isNotEmptyArray(array)) continue;
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    private static boolean isNotEmptyArray(String[] array) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (String s : array) {
            if (s == null || "".equals(s.trim())) continue;
            return true;
        }
        return false;
    }

    private static Class<? extends Replacer>[] joinReplacers(Class<? extends Replacer>[] ... arrays) {
        int length = 0;
        for (Class<? extends Replacer>[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        Class[] result = new Class[length];
        int offset = 0;
        for (Class<? extends Replacer>[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    private static class AnnotationCacheKey {
        private final AnnotatedElement element;
        private final Class<? extends Annotation> annotationType;

        AnnotationCacheKey(AnnotatedElement element, Class<? extends Annotation> annotationType) {
            this.element = element;
            this.annotationType = annotationType;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AnnotationCacheKey) {
                AnnotationCacheKey that = (AnnotationCacheKey)obj;
                return Objects.equals(this.element, that.element) && Objects.equals(this.annotationType, that.annotationType);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.element, this.annotationType);
        }
    }
}

