/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.exporter;

import com.github.database.rider.core.api.exporter.BuilderType;
import com.github.database.rider.core.api.exporter.DataSetExportConfig;
import com.github.database.rider.core.dataset.writer.JSONWriter;
import com.github.database.rider.core.dataset.writer.YMLWriter;
import com.github.database.rider.core.exporter.builder.BuilderExportConfig;
import com.github.database.rider.core.exporter.builder.DataSetBuilderExporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.CachedResultSetTableFactory;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.database.search.TablesDependencyHelper;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.csv.CsvDataSetWriter;
import org.dbunit.dataset.excel.XlsDataSetWriter;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetExporter {
    private static final Pattern TABLE_MATCH_PATTERN = Pattern.compile(".*\\s+from\\s+(\\w+(\\.\\w+)?).*", 2);
    private static Logger log = LoggerFactory.getLogger((String)DataSetExporter.class.getName());
    private static DataSetExporter instance;

    private DataSetExporter() {
    }

    public static DataSetExporter getInstance() {
        if (instance == null) {
            instance = new DataSetExporter();
        }
        return instance;
    }

    public OutputStream export(Connection connection, DataSetExportConfig dataSetExportConfig) throws SQLException, DatabaseUnitException {
        return this.export(connection, dataSetExportConfig, null);
    }

    public OutputStream export(Connection connection, DataSetExportConfig dataSetExportConfig, String schema) throws SQLException, DatabaseUnitException {
        return this.export(new DatabaseConnection(connection, schema), dataSetExportConfig);
    }

    public OutputStream export(DatabaseConnection databaseConnection, DataSetExportConfig dataSetExportConfig) throws SQLException, DatabaseUnitException {
        String outputFile;
        if (databaseConnection == null || databaseConnection.getConnection() == null || databaseConnection.getConnection().isClosed()) {
            throw new RuntimeException("Provide a valid connection to export datasets");
        }
        if (dataSetExportConfig == null) {
            dataSetExportConfig = new DataSetExportConfig();
        }
        if ((outputFile = dataSetExportConfig.getOutputFileName()) == null || "".equals(outputFile)) {
            throw new RuntimeException("Provide output file name to export dataset.");
        }
        if (!outputFile.contains(".")) {
            outputFile = outputFile + "." + dataSetExportConfig.getDataSetFormat().name().toLowerCase();
        }
        if (outputFile.contains("/") && System.getProperty("os.name").toLowerCase().contains("win")) {
            outputFile = outputFile.replace("/", "\\");
        }
        boolean hasIncludes = dataSetExportConfig.getIncludeTables() != null && dataSetExportConfig.getIncludeTables().length > 0;
        DatabaseConfig config = databaseConnection.getConfig();
        config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", (Object)new ForwardOnlyResultSetTableFactory());
        HashSet<String> targetTables = new HashSet<String>();
        if (hasIncludes) {
            String[] dependentTables;
            targetTables.addAll(Arrays.asList(dataSetExportConfig.getIncludeTables()));
            if (dataSetExportConfig.isDependentTables() && (dependentTables = TablesDependencyHelper.getAllDependentTables((IDatabaseConnection)databaseConnection, (String[])dataSetExportConfig.getIncludeTables())) != null && dependentTables.length > 0) {
                targetTables.addAll(Arrays.asList(dependentTables));
            }
        }
        QueryDataSet dataSet = new QueryDataSet((IDatabaseConnection)databaseConnection);
        if (!targetTables.isEmpty() || dataSetExportConfig.getQueryList() != null && dataSetExportConfig.getQueryList().length > 0) {
            this.addQueries(dataSet, dataSetExportConfig.getQueryList(), targetTables);
        } else {
            dataSet = databaseConnection.createDataSet();
        }
        FileOutputStream fos = null;
        FileOutputStream fosDtd = null;
        try {
            boolean generateBuilder;
            if (outputFile.contains(System.getProperty("file.separator"))) {
                String pathWithoutFileName = outputFile.substring(0, outputFile.lastIndexOf(System.getProperty("file.separator")) + 1);
                new File(pathWithoutFileName).mkdirs();
            }
            fos = new FileOutputStream(outputFile);
            switch (dataSetExportConfig.getDataSetFormat()) {
                case XML_DTD: {
                    FlatXmlDataSet.write((IDataSet)dataSet, (OutputStream)fos);
                    fosDtd = new FileOutputStream(outputFile.substring(0, outputFile.lastIndexOf(46)) + ".dtd");
                    FlatDtdDataSet.write((IDataSet)dataSet, (OutputStream)fosDtd);
                    break;
                }
                case XML: {
                    FlatXmlDataSet.write((IDataSet)dataSet, (OutputStream)fos);
                    break;
                }
                case YML: {
                    new YMLWriter(fos).write((IDataSet)dataSet);
                    break;
                }
                case XLS: {
                    config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", (Object)new CachedResultSetTableFactory());
                    new XlsDataSetWriter().write((IDataSet)dataSet, (OutputStream)fos);
                    break;
                }
                case CSV: {
                    outputFile = outputFile.substring(0, outputFile.lastIndexOf(46));
                    CsvDataSetWriter.write((IDataSet)dataSet, (File)new File(outputFile));
                    break;
                }
                case JSON: {
                    config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", (Object)new CachedResultSetTableFactory());
                    new JSONWriter(fos, (IDataSet)dataSet).write();
                    break;
                }
                default: {
                    throw new RuntimeException("Format not supported.");
                }
            }
            log.info("DataSet exported successfully at " + Paths.get(outputFile, new String[0]).toAbsolutePath().toString());
            boolean bl = generateBuilder = BuilderType.NONE != dataSetExportConfig.getBuilderType();
            if (generateBuilder) {
                String builderName = outputFile.substring(0, outputFile.lastIndexOf(46)) + ".java";
                new DataSetBuilderExporter().export((IDataSet)dataSet, new BuilderExportConfig(dataSetExportConfig.getBuilderType(), new File(builderName)));
            }
        }
        catch (Exception e) {
            log.error("Could not export dataset.", (Throwable)e);
            throw new RuntimeException("Could not export dataset.", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    log.error("Could not close file output stream.", (Throwable)e);
                }
            }
            if (fosDtd != null) {
                try {
                    fosDtd.close();
                }
                catch (IOException e) {
                    log.error("Could not close file output stream for dtd file.", (Throwable)e);
                }
            }
            config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", (Object)new CachedResultSetTableFactory());
        }
        return null;
    }

    private void addQueries(QueryDataSet dataSet, String[] queryList, Set<String> targetTables) {
        try {
            for (String targetTable : targetTables) {
                dataSet.addTable(targetTable);
            }
            for (String query : queryList) {
                Matcher m = TABLE_MATCH_PATTERN.matcher(query.split("(?i)select")[1]);
                if (!m.matches()) {
                    log.warn("Unable to parse query. Ignoring '" + query + "'.");
                    continue;
                }
                String table = m.group(1);
                if (targetTables.contains(table)) {
                    log.warn(String.format("Ignoring query %s because its table is already in includedTables.", query));
                    continue;
                }
                dataSet.addTable(table, query);
            }
        }
        catch (Exception e) {
            log.error("Could not add query due to following error.", (Throwable)e);
        }
    }
}

