/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.dataset;

import com.github.database.rider.core.api.connection.ConnectionHolder;
import com.github.database.rider.core.api.dataset.CompareOperation;
import com.github.database.rider.core.api.dataset.DataSetExecutor;
import com.github.database.rider.core.api.dataset.DataSetProvider;
import com.github.database.rider.core.api.dataset.JSONDataSet;
import com.github.database.rider.core.api.dataset.RiderSequenceFilter;
import com.github.database.rider.core.api.dataset.ScriptableDataSet;
import com.github.database.rider.core.api.dataset.SeedStrategy;
import com.github.database.rider.core.api.dataset.YamlDataSet;
import com.github.database.rider.core.assertion.DataSetAssertion;
import com.github.database.rider.core.configuration.ConnectionConfig;
import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.configuration.DataSetConfig;
import com.github.database.rider.core.connection.RiderDataSource;
import com.github.database.rider.core.exception.DataBaseSeedingException;
import com.github.database.rider.core.replacers.Replacer;
import com.github.database.rider.core.util.ContainsFilterTable;
import com.github.database.rider.core.util.TableNameResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.SortedTable;
import org.dbunit.dataset.csv.CsvDataSet;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.SequenceTableFilter;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.ext.mssql.InsertIdentityOperation;
import org.dbunit.operation.CompositeOperation;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetExecutorImpl
implements DataSetExecutor {
    public static final String DEFAULT_EXECUTOR_ID = "default";
    private static final Logger log = LoggerFactory.getLogger(DataSetExecutorImpl.class);
    private static final Map<String, DataSetExecutorImpl> executors = new ConcurrentHashMap<String, DataSetExecutorImpl>();
    private final AtomicBoolean printDBUnitConfig = new AtomicBoolean(true);
    private DBUnitConfig dbUnitConfig;
    private RiderDataSource riderDataSource;
    private ConnectionHolder connectionHolder;
    private final String executorId;
    private boolean isConstraintsDisabled = false;
    private TableNameResolver tableNameResolver;

    public static DataSetExecutorImpl instance(ConnectionHolder connectionHolder) {
        return DataSetExecutorImpl.instance(DEFAULT_EXECUTOR_ID, connectionHolder);
    }

    public static DataSetExecutorImpl instance(String executorId, ConnectionHolder connectionHolder) {
        return DataSetExecutorImpl.instance(executorId, connectionHolder, DBUnitConfig.fromGlobalConfig().executorId(executorId));
    }

    public static DataSetExecutorImpl instance(String executorId, ConnectionHolder connectionHolder, DBUnitConfig dbUnitConfig) {
        DataSetExecutorImpl instance = executors.get(executorId);
        if (instance == null) {
            instance = new DataSetExecutorImpl(executorId, connectionHolder, dbUnitConfig);
            log.debug("creating executor instance " + executorId);
            executors.put(executorId, instance);
        } else if (!instance.dbUnitConfig.isCacheConnection().booleanValue()) {
            instance.setConnectionHolder(connectionHolder);
        }
        return instance;
    }

    private DataSetExecutorImpl(String executorId, ConnectionHolder connectionHolder, DBUnitConfig dbUnitConfig) {
        this.connectionHolder = connectionHolder;
        this.executorId = executorId;
        this.dbUnitConfig = dbUnitConfig;
        this.tableNameResolver = new TableNameResolver(dbUnitConfig);
    }

    @Override
    public void createDataSet(DataSetConfig dataSetConfig) {
        this.printDBUnitConfiguration();
        if (dataSetConfig != null) {
            IDataSet resultingDataSet = null;
            try {
                if (dataSetConfig.isDisableConstraints()) {
                    this.disableConstraints();
                }
                if (this.dbUnitConfig.isAlwaysCleanBefore().booleanValue() || dataSetConfig.isCleanBefore()) {
                    this.clearDatabase(dataSetConfig);
                }
                if (dataSetConfig.getExecuteStatementsBefore() != null && dataSetConfig.getExecuteStatementsBefore().length > 0) {
                    this.executeStatements(dataSetConfig.getExecuteStatementsBefore());
                }
                if (dataSetConfig.getExecuteScriptsBefore() != null && dataSetConfig.getExecuteScriptsBefore().length > 0) {
                    for (int i = 0; i < dataSetConfig.getExecuteScriptsBefore().length; ++i) {
                        this.executeScript(dataSetConfig.getExecuteScriptsBefore()[i]);
                    }
                }
                if (dataSetConfig.hasDataSets() || dataSetConfig.hasDataSetProvider()) {
                    if (dataSetConfig.hasDataSets()) {
                        resultingDataSet = this.loadDataSets(dataSetConfig.getDatasets());
                    } else {
                        resultingDataSet = this.loadDataSetFromDataSetProvider(dataSetConfig.getProvider());
                        if (resultingDataSet == null) {
                            throw new RuntimeException("Provided dataset cannot be null. DataSet provider: " + dataSetConfig.getProvider().getName());
                        }
                    }
                    resultingDataSet = this.performSequenceFiltering(dataSetConfig, resultingDataSet);
                    resultingDataSet = this.performTableOrdering(dataSetConfig, resultingDataSet);
                    resultingDataSet = this.performReplacements(resultingDataSet, this.getReplacerInstances(dataSetConfig.getReplacers()));
                    DatabaseOperation operation = this.getOperation(dataSetConfig);
                    operation.execute((IDatabaseConnection)this.getRiderDataSource().getDBUnitConnection(), resultingDataSet);
                } else {
                    log.warn("Database will not be populated because no dataset has been provided.");
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled() && resultingDataSet != null) {
                    this.logDataSet(resultingDataSet, e);
                }
                throw new DataBaseSeedingException("Could not initialize dataset: " + dataSetConfig, e);
            }
        }
    }

    private boolean isSequenceFilteringEnabled(DBUnitConfig dbUnitConfig, DataSetConfig dataSetConfig) {
        if (dbUnitConfig.isDisableSequenceFiltering().booleanValue()) {
            return false;
        }
        return dataSetConfig.isUseSequenceFiltering();
    }

    private void printDBUnitConfiguration() {
        if (this.printDBUnitConfig.compareAndSet(true, false)) {
            StringBuilder sb = new StringBuilder(150);
            sb.append("cacheConnection: ").append("" + this.dbUnitConfig.isCacheConnection()).append("\n").append("cacheTableNames: ").append(this.dbUnitConfig.isCacheTableNames()).append("\n").append("caseInsensitiveStrategy: ").append((Object)this.dbUnitConfig.getCaseInsensitiveStrategy()).append("\n").append("columnSensing: ").append("" + this.dbUnitConfig.isColumnSensing()).append("\n").append("leakHunter: ").append("" + this.dbUnitConfig.isLeakHunter()).append("\n").append("mergeDataSets: ").append(this.dbUnitConfig.isMergeDataSets()).append("\n").append("mergingStrategy: ").append((Object)this.dbUnitConfig.getMergingStrategy()).append("\n").append("disableSequenceFiltering: ").append(this.dbUnitConfig.isDisableSequenceFiltering()).append("\n").append("alwaysCleanBefore: ").append(this.dbUnitConfig.isAlwaysCleanBefore()).append("\n").append("alwaysCleanAfter: ").append(this.dbUnitConfig.isAlwaysCleanAfter()).append("\n").append("raiseExceptionOnCleanUp: ").append(this.dbUnitConfig.isRaiseExceptionOnCleanUp()).append("\n").append("disablePKCheckFor: ").append("" + this.dbUnitConfig.disablePKCheckFor(new String[0])).append("\n");
            for (Map.Entry<String, Object> entry : this.dbUnitConfig.getProperties().entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue() == null ? "" : entry.getValue()).append("\n");
            }
            log.info("DBUnit configuration for dataset executor '{}':{}", (Object)this.executorId, (Object)sb.toString());
        }
    }

    private void logDataSet(IDataSet resultingDataSet, Exception e) {
        try {
            File datasetFile = Files.createTempFile("dataset-log", ".xml", new FileAttribute[0]).toFile();
            log.info("Saving current dataset to " + datasetFile.getAbsolutePath());
            try (FileOutputStream fos = new FileOutputStream(datasetFile);){
                FlatXmlDataSet.write((IDataSet)resultingDataSet, (OutputStream)fos);
            }
        }
        catch (Exception e1) {
            log.error("Could not log created dataset.", (Throwable)e);
        }
    }

    private IDataSet loadDataSetFromDataSetProvider(Class<? extends DataSetProvider> provider) {
        try {
            DataSetProvider dataSetProvider = provider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return dataSetProvider.provide();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load dataset from provider: " + provider.getName(), e);
        }
    }

    private DatabaseOperation getOperation(DataSetConfig dataSetConfig) {
        SeedStrategy strategy = dataSetConfig.getstrategy();
        if (this.getRiderDataSource().getDBType() == RiderDataSource.DBType.MSSQL && dataSetConfig.isFillIdentityColumns()) {
            switch (strategy) {
                case INSERT: {
                    return InsertIdentityOperation.INSERT;
                }
                case REFRESH: {
                    return InsertIdentityOperation.REFRESH;
                }
                case CLEAN_INSERT: {
                    return InsertIdentityOperation.CLEAN_INSERT;
                }
                case TRUNCATE_INSERT: {
                    return new CompositeOperation(DatabaseOperation.TRUNCATE_TABLE, InsertIdentityOperation.INSERT);
                }
            }
        }
        return strategy.getOperation();
    }

    @Override
    public IDataSet loadDataSet(String name) throws DataSetException, IOException {
        String[] dataSetNames = name.trim().split(",");
        ArrayList<ScriptableDataSet> dataSets = new ArrayList<ScriptableDataSet>();
        boolean sensitiveTableNames = this.dbUnitConfig.isCaseSensitiveTableNames();
        for (String dataSet : dataSetNames) {
            ScriptableDataSet target = null;
            String dataSetName = dataSet.trim();
            String extension = dataSetName.substring(dataSetName.lastIndexOf(46) + 1).toLowerCase();
            URL dataSetUrl = this.getDataSetUrl(dataSetName);
            InputStream datasetStream = null;
            switch (extension) {
                case "yaml": 
                case "yml": {
                    datasetStream = this.getDataSetStream(dataSetUrl);
                    target = new ScriptableDataSet(sensitiveTableNames, new YamlDataSet(datasetStream, this.dbUnitConfig));
                    break;
                }
                case "xml": {
                    datasetStream = this.getDataSetStream(dataSetUrl);
                    target = new ScriptableDataSet(sensitiveTableNames, (IDataSet)new FlatXmlDataSetBuilder().setColumnSensing(this.dbUnitConfig.isColumnSensing().booleanValue()).setCaseSensitiveTableNames(sensitiveTableNames).build(datasetStream));
                    break;
                }
                case "csv": {
                    if (!dataSetUrl.getProtocol().equals("file")) {
                        throw new RuntimeException("Csv datasets can only be accessed from files");
                    }
                    target = new ScriptableDataSet(sensitiveTableNames, (IDataSet)new CsvDataSet(new File(dataSetUrl.getPath()).getParentFile()));
                    break;
                }
                case "xls": {
                    datasetStream = this.getDataSetStream(dataSetUrl);
                    target = new ScriptableDataSet(sensitiveTableNames, (IDataSet)new XlsDataSet(datasetStream));
                    break;
                }
                case "json": {
                    datasetStream = this.getDataSetStream(dataSetUrl);
                    target = new ScriptableDataSet(sensitiveTableNames, (IDataSet)new JSONDataSet(datasetStream));
                    break;
                }
                default: {
                    log.error("Unsupported dataset extension");
                }
            }
            if (target != null) {
                dataSets.add(target);
            }
            if (datasetStream == null) continue;
            datasetStream.close();
        }
        if (dataSets.isEmpty()) {
            throw new RuntimeException("No dataset loaded for name " + name);
        }
        return new CompositeDataSet(dataSets.toArray(new IDataSet[dataSets.size()]), true, sensitiveTableNames);
    }

    @Override
    public IDataSet loadDataSets(String[] datasets) throws DataSetException, IOException {
        ArrayList<IDataSet> dataSetList = new ArrayList<IDataSet>();
        for (String name : datasets) {
            dataSetList.add(this.loadDataSet(name));
        }
        return new CompositeDataSet(dataSetList.toArray(new IDataSet[dataSetList.size()]));
    }

    private IDataSet performTableOrdering(DataSetConfig dataSet, IDataSet target) throws DataSetException {
        if (dataSet.getTableOrdering().length > 0) {
            FilteredDataSet tableOrderingDataset = new FilteredDataSet((ITableFilter)new SequenceTableFilter(dataSet.getTableOrdering(), this.dbUnitConfig.isCaseSensitiveTableNames()), target);
            List<String> tablesNotDeclaredInOrdering = this.getTablesNotPresentInOrdering(target, dataSet);
            if (!tablesNotDeclaredInOrdering.isEmpty()) {
                FilteredDataSet unorderedDataSet = new FilteredDataSet((ITableFilter)new SequenceTableFilter(tablesNotDeclaredInOrdering.toArray(new String[tablesNotDeclaredInOrdering.size()]), this.dbUnitConfig.isCaseSensitiveTableNames()), target);
                target = new CompositeDataSet((IDataSet)unorderedDataSet, (IDataSet)tableOrderingDataset);
            } else {
                target = new FilteredDataSet((ITableFilter)new SequenceTableFilter(dataSet.getTableOrdering(), this.dbUnitConfig.isCaseSensitiveTableNames()), target);
            }
        }
        return target;
    }

    private List<String> getTablesNotPresentInOrdering(IDataSet target, DataSetConfig dataSetConfig) throws DataSetException {
        ArrayList<String> tablesNotPresentInOrdering = new ArrayList<String>();
        List<String> tableOrderingList = Arrays.asList(dataSetConfig.getTableOrdering());
        for (String table : target.getTableNames()) {
            if (tableOrderingList.contains(table) || tableOrderingList.contains(table.toLowerCase()) || tableOrderingList.contains(table.toUpperCase())) continue;
            tablesNotPresentInOrdering.add(table);
        }
        return tablesNotPresentInOrdering;
    }

    private IDataSet performSequenceFiltering(DataSetConfig dataSet, IDataSet target) throws DatabaseUnitException, SQLException {
        boolean sequenceFilteringEnabled = this.isSequenceFilteringEnabled(this.dbUnitConfig, dataSet);
        if (sequenceFilteringEnabled) {
            RiderSequenceFilter filteredTable = new RiderSequenceFilter((IDatabaseConnection)this.getRiderDataSource().getDBUnitConnection(), target.getTableNames(), this.dbUnitConfig);
            target = new FilteredDataSet((ITableFilter)filteredTable, target);
        }
        return target;
    }

    private void disableConstraints() throws SQLException {
        if (!this.isConstraintsDisabled) {
            this.handleConstraints(false);
        }
    }

    @Override
    public void enableConstraints() throws SQLException {
        if (this.isConstraintsDisabled) {
            this.handleConstraints(true);
        }
    }

    public void handleConstraints(boolean enable) throws SQLException {
        try (Statement statement = this.getRiderDataSource().getDBUnitConnection().getConnection().createStatement();){
            switch (this.getRiderDataSource().getDBType()) {
                case HSQLDB: {
                    String hsqlDBFlag = enable ? "TRUE" : "FALSE";
                    this.executeStatements("SET DATABASE REFERENTIAL INTEGRITY " + hsqlDBFlag + ";");
                    break;
                }
                case H2: {
                    String h2DBFlag = enable ? "TRUE" : "FALSE";
                    this.executeStatements("SET REFERENTIAL_INTEGRITY " + h2DBFlag + ";");
                    break;
                }
                case MYSQL: {
                    String mySqlDBFlag = enable ? "1" : "0";
                    this.executeStatements(" SET FOREIGN_KEY_CHECKS=" + mySqlDBFlag + ";");
                    break;
                }
                case POSTGRESQL: {
                    String postgreSqlDBFlag = enable ? "DEFAULT" : "replica";
                    this.executeStatements("SET session_replication_role = " + postgreSqlDBFlag + ";");
                    break;
                }
                case ORACLE: {
                    ResultSet resultSet = null;
                    String schemaName = this.tableNameResolver.resolveSchema(this.getRiderDataSource().getDBUnitConnection().getConnection());
                    String enableDisable = enable ? "enable" : "disable";
                    try {
                        boolean hasSchema = schemaName != null && !"".equals(schemaName.trim());
                        String oracleSqlQueryCondition = enable ? "=" : "<>";
                        resultSet = statement.executeQuery("select TABLE_NAME, CONSTRAINT_NAME from ALL_CONSTRAINTS where CONSTRAINT_TYPE = 'R' " + (hasSchema ? "and OWNER = '" + schemaName + "'" : "") + " and CONSTRAINT_NAME not like 'BIN$%' and STATUS " + oracleSqlQueryCondition + " 'DISABLED'");
                        while (resultSet.next()) {
                            String tableName = resultSet.getString("TABLE_NAME");
                            String escapedTableName = this.tableNameResolver.resolveTableName(tableName, this.getRiderDataSource());
                            String constraintName = resultSet.getString("CONSTRAINT_NAME");
                            String qualifiedTableName = hasSchema ? schemaName + "." + escapedTableName : escapedTableName;
                            this.executeStatements("alter table " + qualifiedTableName + " " + enableDisable + " constraint " + constraintName);
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error while " + enableDisable + " referential constraints on schema " + schemaName, e);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                case MSSQL: {
                    String msSqlDBFlag = enable ? "with check check" : "nocheck";
                    Set<String> tables = this.tableNameResolver.getTableNames(this.getRiderDataSource());
                    for (String tableName : tables) {
                        this.executeStatements("alter table " + tableName + " " + msSqlDBFlag + " constraint all");
                    }
                    break;
                }
            }
            this.isConstraintsDisabled = !this.isConstraintsDisabled;
        }
    }

    @Override
    public void executeStatements(String ... statements) {
        if (statements != null && statements.length > 0 && !"".equals(statements[0].trim())) {
            Statement statement = null;
            try {
                Connection connection = this.getRiderDataSource().getDBUnitConnection().getConnection();
                this.getRiderDataSource().setConnectionAutoCommit(false);
                statement = connection.createStatement(1005, 1008);
                for (String stm : statements) {
                    statement.addBatch(stm);
                }
                statement.executeBatch();
                connection.commit();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute statements:" + e.getMessage(), e);
            }
            finally {
                try {
                    this.getRiderDataSource().resetConnectionAutoCommit();
                }
                catch (SQLException e) {
                    log.error("Could not reset connection auto commit", (Throwable)e);
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException ex) {
                        log.error("Could close statement.", (Throwable)ex);
                    }
                }
            }
        }
    }

    private IDataSet performReplacements(IDataSet dataSet, List<Replacer> replacersList) {
        if ((replacersList == null || replacersList.isEmpty()) && this.dbUnitConfig.getProperties().containsKey("replacers") && ((replacersList = (List)this.dbUnitConfig.getProperties().get("replacers")) == null || replacersList.isEmpty())) {
            return dataSet;
        }
        ReplacementDataSet replacementSet = new ReplacementDataSet(dataSet);
        HashSet<Replacer> replacers = new HashSet<Replacer>(replacersList);
        for (Replacer replacer : replacers) {
            replacer.addReplacements(replacementSet);
        }
        return replacementSet;
    }

    private void setConnectionHolder(ConnectionHolder connectionHolder) {
        this.connectionHolder = connectionHolder;
        this.riderDataSource = null;
    }

    @Override
    public void initConnectionFromConfig(final ConnectionConfig connectionConfig) {
        this.setConnectionHolder(new ConnectionHolder(){

            @Override
            public Connection getConnection() {
                return DataSetExecutorImpl.this.getConnectionFromConfig(connectionConfig);
            }
        });
    }

    private Connection getConnectionFromConfig(ConnectionConfig connectionConfig) {
        if ("".equals(connectionConfig.getUrl())) {
            throw new RuntimeException("JDBC connection url cannot be empty");
        }
        if (!"".equals(connectionConfig.getDriver())) {
            try {
                Class.forName(connectionConfig.getDriver());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return DriverManager.getConnection(connectionConfig.getUrl(), connectionConfig.getUser(), connectionConfig.getPassword());
        }
        catch (SQLException e) {
            log.error("Could not create connection from configuration.", (Throwable)e);
            throw new RuntimeException("Could not create connection from configuration. See documentation here: https://github.com/database-rider/database-rider#jdbc-connection");
        }
    }

    @Deprecated
    public Connection getConnection() {
        try {
            return this.getRiderDataSource().getDBUnitConnection().getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return 17 * (this.executorId == null ? 0 : this.executorId.hashCode());
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataSetExecutorImpl)) {
            return false;
        }
        DataSetExecutorImpl otherExecutor = (DataSetExecutorImpl)other;
        if (this.executorId == null || otherExecutor.getExecutorId() == null) {
            return false;
        }
        return this.executorId.equals(otherExecutor.getExecutorId());
    }

    @Override
    public String getExecutorId() {
        return this.executorId;
    }

    public static DataSetExecutorImpl getExecutorById(String id) {
        return executors.get(id);
    }

    private URL getDataSetUrl(String dataSet) {
        String dataSetWithoutLeadingSlash = dataSet.startsWith("/") ? dataSet.substring(1) : dataSet;
        URL url = Thread.currentThread().getContextClassLoader().getResource(dataSetWithoutLeadingSlash);
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource("datasets/" + dataSetWithoutLeadingSlash);
        }
        if (url == null) {
            try {
                url = new URL(dataSet);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null) {
            throw new RuntimeException(String.format("The dataset '%s' is neither a valid URL nor could be found under 'resources' or 'resources/%s' directory.", dataSet, "datasets/"));
        }
        return url;
    }

    private InputStream getDataSetStream(URL url) {
        InputStream inputStream;
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("The dataset '%s' cannot be accessed", url.getPath()));
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDatabase(DataSetConfig config) throws SQLException {
        try {
            this.disableConstraints();
            LinkedList<String> cleanupStatements = new LinkedList<String>();
            if (config != null && config.getTableOrdering() != null && config.getTableOrdering().length > 0) {
                for (String table : config.getTableOrdering()) {
                    if (table.toUpperCase().contains(DBUnitConfig.Constants.SEQUENCE_TABLE_NAME)) continue;
                    String escapedTableName = this.tableNameResolver.resolveTableName(table, this.getRiderDataSource());
                    cleanupStatements.add("DELETE FROM " + escapedTableName + " where 1=1");
                }
            }
            Set<String> tables = this.tableNameResolver.getTableNames(this.getRiderDataSource());
            List<String> tablesToSkipCleaning = this.getTablesToSkipOnCleaning(config);
            for (String tableName : tables) {
                if (this.shouldSkipFromCleaning(tablesToSkipCleaning, tableName) || tableName.toUpperCase().contains(DBUnitConfig.Constants.SEQUENCE_TABLE_NAME)) continue;
                cleanupStatements.add("DELETE FROM " + tableName + " where 1=1");
            }
            if (!cleanupStatements.isEmpty()) {
                this.executeStatements(cleanupStatements.toArray(new String[cleanupStatements.size()]));
            }
        }
        catch (Exception e) {
            if (this.dbUnitConfig.isRaiseExceptionOnCleanUp()) {
                throw new RuntimeException("Could not clean database before test.", e);
            }
            log.warn("Could not clean database before test.", (Throwable)e);
        }
        finally {
            if (!config.isDisableConstraints()) {
                this.enableConstraints();
            }
        }
    }

    private List<String> getTablesToSkipOnCleaning(DataSetConfig config) {
        List<String> tablesToSkipOnCleaning;
        List<String> list = tablesToSkipOnCleaning = config.getSkipCleaningFor() != null ? Arrays.asList(config.getSkipCleaningFor()) : Collections.emptyList();
        if (!tablesToSkipOnCleaning.isEmpty()) {
            for (String tableName : tablesToSkipOnCleaning) {
                tablesToSkipOnCleaning.set(tablesToSkipOnCleaning.indexOf(tableName), this.tableNameResolver.resolveTableName(tableName, this.getRiderDataSource()));
            }
        }
        return tablesToSkipOnCleaning;
    }

    private boolean shouldSkipFromCleaning(List<String> tablesToSkipCleaning, String tableName) {
        boolean skip = tablesToSkipCleaning.contains(tableName);
        if (!skip && tableName.contains(".")) {
            skip = tablesToSkipCleaning.contains(tableName.substring(tableName.indexOf(".") + 1));
        }
        return skip;
    }

    @Override
    public void executeScript(String scriptPath) {
        if (scriptPath != null && !"".equals(scriptPath)) {
            String scriptPathWithoutLeadingSlash = scriptPath.startsWith("/") ? scriptPath.substring(1) : scriptPath;
            URL resource = Thread.currentThread().getContextClassLoader().getResource(scriptPathWithoutLeadingSlash.trim());
            if (resource == null) {
                resource = Thread.currentThread().getContextClassLoader().getResource("scripts/" + scriptPathWithoutLeadingSlash.trim());
            }
            if (resource == null) {
                throw new RuntimeException(String.format("Could not find script %s in classpath", scriptPath));
            }
            String[] scriptsStatements = this.readScriptStatements(resource);
            if (scriptsStatements != null && scriptsStatements.length > 0) {
                this.executeStatements(scriptsStatements);
            }
        }
    }

    String[] readScriptStatements(URL resource) {
        if ("jar".equals(resource.getProtocol())) {
            return this.readScriptStatementsFromJar(resource);
        }
        return this.readScriptStatementsFromFile(resource);
    }

    private String[] readScriptStatementsFromJar(URL resource) {
        String[] stringArray;
        String jarEntry = "jar:" + resource.getFile();
        Object r = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(new URL(jarEntry).openConnection().getInputStream(), StandardCharsets.UTF_8));
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            List<String> statements = this.splitScript(sb.toString());
            stringArray = statements.toArray(new String[statements.size()]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Could not read script file %s.", jarEntry), e);
            }
        }
        br.close();
        return stringArray;
    }

    private String[] readScriptStatementsFromFile(URL resource) {
        String[] stringArray;
        File scriptFile = this.getFileFromURL(resource);
        if (scriptFile == null) {
            return null;
        }
        int lineNum = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(scriptFile), StandardCharsets.UTF_8));
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
                ++lineNum;
            }
            List<String> statements = this.splitScript(sb.toString());
            stringArray = statements.toArray(new String[statements.size()]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format(String.format("Could not read script file %s. Error in line %d.", scriptFile.getAbsolutePath(), lineNum), e));
            }
        }
        br.close();
        return stringArray;
    }

    private List<String> splitScript(String script) {
        String separator = ";";
        String[] commentPrefixes = new String[]{"#", "--"};
        String blockCommentStartDelimiter = "/*";
        String blockCommentEndDelimiter = "*/";
        return this.splitScript(script, separator, commentPrefixes, blockCommentStartDelimiter, blockCommentEndDelimiter);
    }

    private List<String> splitScript(String script, String separator, String[] commentPrefixes, String blockCommentStartDelimiter, String blockCommentEndDelimiter) {
        String lastString;
        LinkedList<String> statements = new LinkedList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inEscape = false;
        for (int i = 0; i < script.length(); ++i) {
            int c = script.charAt(i);
            if (inEscape) {
                inEscape = false;
                sb.append((char)c);
                continue;
            }
            if (c == 92) {
                inEscape = true;
                sb.append((char)c);
                continue;
            }
            if (!inDoubleQuote && c == 39) {
                inSingleQuote = !inSingleQuote;
            } else if (!inSingleQuote && c == 34) {
                boolean bl = inDoubleQuote = !inDoubleQuote;
            }
            if (!inSingleQuote && !inDoubleQuote) {
                if (script.startsWith(separator, i)) {
                    if (sb.length() <= 0) continue;
                    statements.add(sb.toString());
                    sb = new StringBuilder();
                    continue;
                }
                boolean startWithCommentPrefix = false;
                for (String commentPrefix : commentPrefixes) {
                    startWithCommentPrefix |= script.startsWith(commentPrefix, i);
                }
                if (startWithCommentPrefix) {
                    int indexOfNextNewline = script.indexOf("\n", i);
                    if (indexOfNextNewline <= i) break;
                    i = indexOfNextNewline;
                    continue;
                }
                if (script.startsWith(blockCommentStartDelimiter, i)) {
                    int indexOfCommentEnd = script.indexOf(blockCommentEndDelimiter, i);
                    if (indexOfCommentEnd > i) {
                        i = indexOfCommentEnd + blockCommentEndDelimiter.length() - 1;
                        continue;
                    }
                    throw new RuntimeException("Missing block comment end delimiter: " + blockCommentEndDelimiter);
                }
                if (c == 32 || c == 10 || c == 9) {
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue;
                    c = 32;
                }
            }
            sb.append((char)c);
        }
        if ((lastString = sb.toString().trim()).length() > 0) {
            statements.add(lastString);
        }
        return statements;
    }

    private File getFileFromURL(URL resource) {
        try {
            return new File(resource.toURI());
        }
        catch (URISyntaxException e) {
            log.error(String.format("Could not read script file %s.", resource.getFile()), (Throwable)e);
            return null;
        }
    }

    @Override
    public void compareCurrentDataSetWith(DataSetConfig expectedDataSetConfig, String[] excludeCols, Class<? extends Replacer>[] replacers, String[] orderBy, CompareOperation compareOperation) throws DatabaseUnitException {
        IDataSet current = null;
        IDataSet expected = null;
        List<Replacer> expectedDataSetReplacers = this.getReplacerInstances(replacers);
        try {
            current = this.getRiderDataSource().getDBUnitConnection().createDataSet();
            if (expectedDataSetConfig.hasDataSetProvider()) {
                expected = this.loadDataSetFromDataSetProvider(expectedDataSetConfig.getProvider());
            } else if (expectedDataSetConfig.hasDataSets()) {
                expected = this.loadDataSets(expectedDataSetConfig.getDatasets());
            }
            if (expected == null) {
                throw new RuntimeException("Expected dataset was not provided.");
            }
            expected = this.performReplacements(expected, expectedDataSetReplacers);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create dataset to compare.", e);
        }
        String[] tableNames = null;
        try {
            tableNames = expected.getTableNames();
        }
        catch (DataSetException e) {
            throw new RuntimeException("Could not extract dataset table names.", e);
        }
        for (String tableName : tableNames) {
            ITable expectedTable = null;
            ITable actualTable = null;
            try {
                expectedTable = expected.getTable(tableName);
                actualTable = current.getTable(tableName);
            }
            catch (DataSetException e) {
                throw new RuntimeException("DataSet comparison failed due to following exception: ", e);
            }
            if (orderBy != null && orderBy.length > 0) {
                ArrayList<String> validOrderByColumns = new ArrayList<String>();
                for (int i = 0; i < expectedTable.getRowCount(); ++i) {
                    for (String orderColumn : orderBy) {
                        try {
                            if (expectedTable.getValue(i, orderColumn).toString().startsWith("regex:")) {
                                throw new IllegalArgumentException(String.format("The orderBy column %s cannot use regex matching on table %s.", orderColumn, tableName));
                            }
                            validOrderByColumns.add(orderColumn);
                        }
                        catch (NullPointerException | NoSuchColumnException throwable) {
                            // empty catch block
                        }
                    }
                }
                expectedTable = new SortedTable(expectedTable, validOrderByColumns.toArray(new String[0]));
                actualTable = new SortedTable(actualTable, validOrderByColumns.toArray(new String[0]));
            }
            ITable filteredActualTable = DefaultColumnFilter.includedColumnsTable((ITable)actualTable, (Column[])expectedTable.getTableMetaData().getColumns());
            switch (compareOperation) {
                case CONTAINS: {
                    filteredActualTable = new ContainsFilterTable(filteredActualTable, expectedTable, Arrays.asList(excludeCols));
                    break;
                }
            }
            DataSetAssertion.assertEqualsIgnoreCols(expectedTable, filteredActualTable, excludeCols);
        }
    }

    private List<Replacer> getReplacerInstances(Class<? extends Replacer>[] replacers) {
        ArrayList<Replacer> replacerInstances = new ArrayList<Replacer>();
        if (replacers != null && replacers.length > 0) {
            for (Class<? extends Replacer> replacerClass : replacers) {
                try {
                    replacerInstances.add(replacerClass.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(replacerClass.getName() + " could not be instantiated as Replacer");
                }
            }
        }
        return replacerInstances;
    }

    @Override
    public void compareCurrentDataSetWith(DataSetConfig expectedDataSetConfig, String[] excludeCols) throws DatabaseUnitException {
        this.compareCurrentDataSetWith(expectedDataSetConfig, excludeCols, null, null);
    }

    @Override
    public void compareCurrentDataSetWith(DataSetConfig expectedDataSetConfig, String[] excludeCols, Class<? extends Replacer>[] replacers, String[] orderBy) throws DatabaseUnitException {
        this.compareCurrentDataSetWith(expectedDataSetConfig, excludeCols, replacers, orderBy, CompareOperation.EQUALS);
    }

    @Override
    public void setDBUnitConfig(DBUnitConfig dbUnitConfig) {
        if (!this.dbUnitConfig.equals(dbUnitConfig)) {
            this.dbUnitConfig = dbUnitConfig;
            this.riderDataSource = null;
            this.tableNameResolver = new TableNameResolver(dbUnitConfig);
        }
    }

    @Override
    public DBUnitConfig getDBUnitConfig() {
        return this.dbUnitConfig;
    }

    @Override
    public RiderDataSource getRiderDataSource() {
        if (this.riderDataSource == null) {
            if (this.connectionHolder == null) {
                this.initConnectionFromConfig(this.dbUnitConfig.getConnectionConfig());
            }
            this.riderDataSource = new RiderDataSource(this.connectionHolder, this.dbUnitConfig);
        }
        return this.riderDataSource;
    }

    public void clearRiderDataSource() {
        this.riderDataSource = null;
    }
}

