/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables.repository;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.datatables.repository.DataTablesRepository;
import org.springframework.data.jpa.datatables.repository.DataTablesRepositoryImpl;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class DataTablesRepositoryFactoryBean<R extends JpaRepository<T, ID>, T, ID extends Serializable>
extends JpaRepositoryFactoryBean<R, T, ID> {
    public DataTablesRepositoryFactoryBean(Class<? extends R> repositoryInterface) {
        super(repositoryInterface);
    }

    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        return new DataTablesRepositoryFactory(entityManager);
    }

    private static class DataTablesRepositoryFactory<T, ID extends Serializable>
    extends JpaRepositoryFactory {
        public DataTablesRepositoryFactory(EntityManager entityManager) {
            super(entityManager);
        }

        protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
            Class repositoryInterface = metadata.getRepositoryInterface();
            if (DataTablesRepository.class.isAssignableFrom(repositoryInterface)) {
                return DataTablesRepositoryImpl.class;
            }
            return super.getRepositoryBaseClass(metadata);
        }
    }
}

