/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.FetchParent;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hibernate.query.criteria.internal.path.AbstractPathImpl;
import org.springframework.data.jpa.datatables.AbstractPredicateBuilder;
import org.springframework.data.jpa.datatables.Filter;
import org.springframework.data.jpa.datatables.Node;
import org.springframework.data.jpa.datatables.mapping.DataTablesInput;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;

public class SpecificationBuilder<T>
extends AbstractPredicateBuilder<Specification<T>> {
    public SpecificationBuilder(DataTablesInput input) {
        super(input);
    }

    @Override
    public Specification<T> build() {
        return new DataTablesSpecification();
    }

    private class DataTablesSpecification<S>
    implements Specification<S> {
        private List<Predicate> columnPredicates = new ArrayList<Predicate>();
        private List<Predicate> globalPredicates = new ArrayList<Predicate>();

        private DataTablesSpecification() {
        }

        public Predicate toPredicate(@NonNull Root<S> root, @NonNull CriteriaQuery<?> query, @NonNull CriteriaBuilder criteriaBuilder) {
            boolean isCountQuery;
            this.initPredicatesRecursively(SpecificationBuilder.this.tree, (From<S, S>)root, (FetchParent<S, S>)root, criteriaBuilder);
            boolean bl = isCountQuery = query.getResultType() == Long.class;
            if (isCountQuery) {
                root.getFetches().clear();
            }
            return this.createFinalPredicate(criteriaBuilder);
        }

        private void initPredicatesRecursively(Node<Filter> node, From<S, S> from, FetchParent<S, S> fetch, CriteriaBuilder criteriaBuilder) {
            if (node.isLeaf()) {
                boolean hasColumnFilter;
                boolean bl = hasColumnFilter = node.getData() != null;
                if (hasColumnFilter) {
                    Filter columnFilter = node.getData();
                    this.columnPredicates.add(columnFilter.createPredicate(from, criteriaBuilder, node.getName()));
                } else if (SpecificationBuilder.this.hasGlobalFilter) {
                    Filter globalFilter = (Filter)SpecificationBuilder.this.tree.getData();
                    this.globalPredicates.add(globalFilter.createPredicate(from, criteriaBuilder, node.getName()));
                }
            }
            for (Node<Filter> child : node.getChildren()) {
                Path path = from.get(child.getName());
                if (path instanceof AbstractPathImpl && ((AbstractPathImpl)path).getAttribute().isCollection()) continue;
                if (child.isLeaf()) {
                    this.initPredicatesRecursively(child, from, fetch, criteriaBuilder);
                    continue;
                }
                Join join = from.join(child.getName(), JoinType.LEFT);
                Fetch childFetch = fetch.fetch(child.getName(), JoinType.LEFT);
                this.initPredicatesRecursively(child, (From<S, S>)join, (FetchParent<S, S>)childFetch, criteriaBuilder);
            }
        }

        private Predicate createFinalPredicate(CriteriaBuilder criteriaBuilder) {
            ArrayList<Predicate> allPredicates = new ArrayList<Predicate>(this.columnPredicates);
            if (!this.globalPredicates.isEmpty()) {
                allPredicates.add(criteriaBuilder.or(this.globalPredicates.toArray(new Predicate[0])));
            }
            return allPredicates.isEmpty() ? criteriaBuilder.conjunction() : criteriaBuilder.and(allPredicates.toArray(new Predicate[0]));
        }
    }
}

