/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.jpa.datatables.AbstractPredicateBuilder;
import org.springframework.data.jpa.datatables.Filter;
import org.springframework.data.jpa.datatables.Node;
import org.springframework.data.jpa.datatables.mapping.DataTablesInput;

public class PredicateBuilder
extends AbstractPredicateBuilder<Predicate> {
    private final PathBuilder<?> entity;
    private List<Predicate> columnPredicates = new ArrayList<Predicate>();
    private List<Predicate> globalPredicates = new ArrayList<Predicate>();

    public PredicateBuilder(PathBuilder<?> entity, DataTablesInput input) {
        super(input);
        this.entity = entity;
    }

    @Override
    public Predicate build() {
        this.initPredicatesRecursively(this.tree, this.entity);
        return this.createFinalPredicate();
    }

    private void initPredicatesRecursively(Node<Filter> node, PathBuilder<?> pathBuilder) {
        if (node.isLeaf()) {
            boolean hasColumnFilter;
            boolean bl = hasColumnFilter = node.getData() != null;
            if (hasColumnFilter) {
                Filter columnFilter = node.getData();
                this.columnPredicates.add(columnFilter.createPredicate(pathBuilder, node.getName()));
            } else if (this.hasGlobalFilter) {
                Filter globalFilter = (Filter)this.tree.getData();
                this.globalPredicates.add(globalFilter.createPredicate(pathBuilder, node.getName()));
            }
        }
        for (Node<Filter> child : node.getChildren()) {
            this.initPredicatesRecursively(child, child.isLeaf() ? pathBuilder : pathBuilder.get(child.getName()));
        }
    }

    private Predicate createFinalPredicate() {
        BooleanBuilder predicate = new BooleanBuilder();
        for (Predicate columnPredicate : this.columnPredicates) {
            predicate = predicate.and(columnPredicate);
        }
        if (!this.globalPredicates.isEmpty()) {
            predicate = predicate.andAnyOf(this.globalPredicates.toArray(new Predicate[0]));
        }
        return predicate;
    }
}

