/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables;

import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringOperation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.springframework.data.jpa.datatables.GlobalFilter;

class ColumnFilter
extends GlobalFilter {
    private final Set<String> values;
    private final Set<Boolean> booleanValues;
    private boolean addNullCase;
    private boolean isBooleanComparison = true;

    ColumnFilter(String filterValue) {
        super(filterValue);
        HashSet<String> values = new HashSet<String>();
        for (String value : filterValue.split("\\+")) {
            if ("NULL".equals(value)) {
                this.addNullCase = true;
                continue;
            }
            this.isBooleanComparison &= this.isBoolean(value);
            values.add(this.nullOrTrimmedValue(value));
        }
        this.values = Collections.unmodifiableSet(values);
        HashSet<Boolean> booleanValues = new HashSet<Boolean>();
        if (this.isBooleanComparison) {
            for (String value : values) {
                booleanValues.add(Boolean.valueOf(value));
            }
        }
        this.booleanValues = Collections.unmodifiableSet(booleanValues);
    }

    private boolean isBoolean(String filterValue) {
        return "TRUE".equalsIgnoreCase(filterValue) || "FALSE".equalsIgnoreCase(filterValue);
    }

    @Override
    public com.querydsl.core.types.Predicate createPredicate(PathBuilder<?> pathBuilder, String attributeName) {
        BooleanExpression predicate;
        StringOperation path = Expressions.stringOperation((Operator)Ops.STRING_CAST, (com.querydsl.core.types.Expression[])new com.querydsl.core.types.Expression[]{pathBuilder.get(attributeName)});
        BooleanPath booleanPath = pathBuilder.getBoolean(attributeName);
        if (this.values.isEmpty()) {
            return this.addNullCase ? path.isNull() : null;
        }
        if (this.isBasicFilter()) {
            return super.createPredicate(pathBuilder, attributeName);
        }
        BooleanExpression booleanExpression = predicate = this.isBooleanComparison ? booleanPath.in(this.booleanValues) : path.in(this.values);
        if (this.addNullCase) {
            predicate = predicate.or((com.querydsl.core.types.Predicate)path.isNull());
        }
        return predicate;
    }

    @Override
    public Predicate createPredicate(From<?, ?> from, CriteriaBuilder criteriaBuilder, String attributeName) {
        Path expression = from.get(attributeName);
        if (this.values.isEmpty()) {
            return this.addNullCase ? expression.isNull() : criteriaBuilder.conjunction();
        }
        if (this.isBasicFilter()) {
            return super.createPredicate(from, criteriaBuilder, attributeName);
        }
        Predicate predicate = this.isBooleanComparison ? expression.in(this.booleanValues) : expression.as(String.class).in(this.values);
        if (this.addNullCase) {
            predicate = criteriaBuilder.or((Expression)predicate, (Expression)expression.isNull());
        }
        return predicate;
    }

    private boolean isBasicFilter() {
        return this.values.size() == 1 && !this.addNullCase && !this.isBooleanComparison;
    }
}

