/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.dynamic;

import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.EmptyAtom;
import org.scilab.forge.jlatexmath.core.StrutBox;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;
import org.scilab.forge.jlatexmath.core.TeXFormula;
import org.scilab.forge.jlatexmath.dynamic.ExternalConverter;
import org.scilab.forge.jlatexmath.dynamic.ExternalConverterFactory;

public class DynamicAtom
extends Atom {
    private static ExternalConverterFactory ecFactory;
    private ExternalConverter converter;
    private TeXFormula formula = new TeXFormula();
    private String externalCode;
    private boolean insert;
    private boolean refreshed;

    public DynamicAtom(String externalCode, String option) {
        this.externalCode = externalCode;
        if (ecFactory != null) {
            this.converter = ecFactory.getExternalConverter();
        }
        if (option != null && option.equals("i")) {
            this.insert = true;
        }
    }

    public static boolean hasAnExternalConverterFactory() {
        return ecFactory != null;
    }

    public static void setExternalConverterFactory(ExternalConverterFactory factory) {
        ecFactory = factory;
    }

    public boolean getInsertMode() {
        return this.insert;
    }

    public Atom getAtom() {
        if (!this.refreshed) {
            this.formula.setLaTeX(this.converter.getLaTeXString(this.externalCode));
            this.refreshed = true;
        }
        if (this.formula.root == null) {
            return new EmptyAtom();
        }
        return this.formula.root;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        if (this.converter != null) {
            if (this.refreshed) {
                this.refreshed = false;
            } else {
                this.formula.setLaTeX(this.converter.getLaTeXString(this.externalCode));
            }
            if (this.formula.root != null) {
                return this.formula.root.createBox(env);
            }
        }
        return new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
    }
}

