/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.HorizontalBox;
import org.scilab.forge.jlatexmath.core.SpaceAtom;
import org.scilab.forge.jlatexmath.core.StrutBox;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;
import org.scilab.forge.jlatexmath.core.TeXFont;
import org.scilab.forge.jlatexmath.core.VerticalBox;
import org.scilab.forge.jlatexmath.core.XLeftRightArrowFactory;

public class UnderOverArrowAtom
extends Atom {
    private Atom base;
    private String arrow;
    private boolean over;
    private boolean left = false;
    private boolean dble = false;

    public UnderOverArrowAtom(Atom base, boolean left, boolean over) {
        this.base = base;
        this.arrow = left ? "leftarrow" : "rightarrow";
        this.left = left;
        this.over = over;
    }

    public UnderOverArrowAtom(Atom base, boolean over) {
        this.base = base;
        this.over = over;
        this.dble = true;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        Box arrow;
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        Box b = this.base != null ? this.base.createBox(env) : new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
        float sep = new SpaceAtom(3, 1.0f, 0.0f, 0.0f).createBox(env).getWidth();
        if (this.dble) {
            arrow = XLeftRightArrowFactory.create(env, b.getWidth());
            sep = 4.0f * sep;
        } else {
            arrow = XLeftRightArrowFactory.create(this.left, env, b.getWidth());
            sep = -sep;
        }
        VerticalBox vb = new VerticalBox();
        if (this.over) {
            vb.add(arrow);
            vb.add(new HorizontalBox(b, arrow.getWidth(), 2));
            float h = vb.getDepth() + vb.getHeight();
            vb.setDepth(b.getDepth());
            vb.setHeight(h - b.getDepth());
        } else {
            vb.add(new HorizontalBox(b, arrow.getWidth(), 2));
            vb.add(new StrutBox(0.0f, sep, 0.0f, 0.0f));
            vb.add(arrow);
            float h = vb.getDepth() + vb.getHeight();
            vb.setDepth(h - b.getHeight());
            vb.setHeight(b.getHeight());
        }
        return vb;
    }
}

