/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Canvas;
import android.graphics.Color;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.HorizontalBox;
import org.scilab.forge.jlatexmath.core.Insets;
import org.scilab.forge.jlatexmath.core.VerticalBox;

public class TeXIcon {
    private static final Integer defaultColor = Color.rgb((int)0, (int)0, (int)0);
    public static float defaultSize = -1.0f;
    public static float magFactor = 0.0f;
    private Box box;
    private final float size;
    private Insets insets = new Insets(0, 0, 0, 0);
    private Integer fg = null;
    public boolean isColored = false;

    protected TeXIcon(Box b, float size) {
        this(b, size, false);
    }

    protected TeXIcon(Box b, float size, boolean trueValues) {
        this.box = b;
        if (defaultSize != -1.0f) {
            size = defaultSize;
        }
        this.size = magFactor != 0.0f ? size * Math.abs(magFactor) : size;
        if (!trueValues) {
            this.insets.top += (int)(0.18f * size);
            this.insets.bottom += (int)(0.18f * size);
            this.insets.left += (int)(0.18f * size);
            this.insets.right += (int)(0.18f * size);
        }
    }

    public void setForeground(Integer fg) {
        this.fg = fg;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets, boolean trueValues) {
        this.insets = insets;
        if (!trueValues) {
            this.insets.top += (int)(0.18f * this.size);
            this.insets.bottom += (int)(0.18f * this.size);
            this.insets.left += (int)(0.18f * this.size);
            this.insets.right += (int)(0.18f * this.size);
        }
    }

    public void setInsets(Insets insets) {
        this.setInsets(insets, false);
    }

    public void setIconWidth(int width, int alignment) {
        float diff = width - this.getIconWidth();
        if (diff > 0.0f) {
            this.box = new HorizontalBox(this.box, this.box.getWidth() + diff, alignment);
        }
    }

    public void setIconHeight(int height, int alignment) {
        float diff = height - this.getIconHeight();
        if (diff > 0.0f) {
            this.box = new VerticalBox(this.box, diff, alignment);
        }
    }

    public int getIconHeight() {
        return (int)((double)(this.box.getHeight() * this.size) + 0.99 + (double)this.insets.top) + (int)((double)(this.box.getDepth() * this.size) + 0.99 + (double)this.insets.bottom);
    }

    public int getIconDepth() {
        return (int)((double)(this.box.getDepth() * this.size) + 0.99 + (double)this.insets.bottom);
    }

    public int getIconWidth() {
        return (int)((double)(this.box.getWidth() * this.size) + 0.99 + (double)this.insets.left + (double)this.insets.right);
    }

    public float getTrueIconHeight() {
        return (this.box.getHeight() + this.box.getDepth()) * this.size;
    }

    public float getTrueIconDepth() {
        return this.box.getDepth() * this.size;
    }

    public float getTrueIconWidth() {
        return this.box.getWidth() * this.size;
    }

    public float getBaseLine() {
        return (float)(((double)(this.box.getHeight() * this.size) + 0.99 + (double)this.insets.top) / ((double)((this.box.getHeight() + this.box.getDepth()) * this.size) + 0.99 + (double)this.insets.top + (double)this.insets.bottom));
    }

    public Box getBox() {
        return this.box;
    }

    public void paintIcon(Canvas g, int x, int y) {
        Canvas g2 = g;
        g2.scale(this.size, this.size);
        this.box.draw(g2, (float)(x + this.insets.left) / this.size, (float)(y + this.insets.top) / this.size + this.box.getHeight());
    }
}

