/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.core.AjLatexMath;
import org.scilab.forge.jlatexmath.core.ResourceParseException;
import org.scilab.forge.jlatexmath.core.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TeXFormulaSettingsParser {
    public static final String RESOURCE_NAME = "TeXFormulaSettings.xml";
    public static final String CHARTODEL_MAPPING_EL = "Map";
    private Element root;

    public TeXFormulaSettingsParser() throws ResourceParseException, IOException {
        this(AjLatexMath.getAssetManager().open(RESOURCE_NAME), RESOURCE_NAME);
    }

    public TeXFormulaSettingsParser(InputStream file, String name) throws ResourceParseException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            this.root = factory.newDocumentBuilder().parse(file).getDocumentElement();
        }
        catch (Exception e) {
            throw new XMLResourceParseException(name, e);
        }
        file.close();
    }

    public void parseSymbolToFormulaMappings(String[] mappings, String[] textMappings) throws ResourceParseException {
        Element charToSymbol = (Element)this.root.getElementsByTagName("CharacterToFormulaMappings").item(0);
        if (charToSymbol != null) {
            TeXFormulaSettingsParser.addFormulaToMap(charToSymbol.getElementsByTagName(CHARTODEL_MAPPING_EL), mappings, textMappings);
        }
    }

    public void parseSymbolMappings(String[] mappings, String[] textMappings) throws ResourceParseException {
        Element charToSymbol = (Element)this.root.getElementsByTagName("CharacterToSymbolMappings").item(0);
        if (charToSymbol != null) {
            TeXFormulaSettingsParser.addToMap(charToSymbol.getElementsByTagName(CHARTODEL_MAPPING_EL), mappings, textMappings);
        }
    }

    private static void addToMap(NodeList mapList, String[] tableMath, String[] tableText) throws ResourceParseException {
        for (int i = 0; i < mapList.getLength(); ++i) {
            Element map = (Element)mapList.item(i);
            String ch = map.getAttribute("char");
            String symbol = map.getAttribute("symbol");
            String text = map.getAttribute("text");
            if (ch.equals("")) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getTagName(), "char", null);
            }
            if (symbol.equals("")) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getTagName(), "symbol", null);
            }
            if (ch.length() != 1) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getTagName(), "char", "must have a value that contains exactly 1 character!");
            }
            tableMath[ch.charAt((int)0)] = symbol;
            if (tableText == null || text.equals("")) continue;
            tableText[ch.charAt((int)0)] = text;
        }
    }

    private static void addFormulaToMap(NodeList mapList, String[] tableMath, String[] tableText) throws ResourceParseException {
        for (int i = 0; i < mapList.getLength(); ++i) {
            Element map = (Element)mapList.item(i);
            String ch = map.getAttribute("char");
            String formula = map.getAttribute("formula");
            String text = map.getAttribute("text");
            if (ch.equals("")) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getTagName(), "char", null);
            }
            if (formula.equals("")) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getTagName(), "formula", null);
            }
            if (ch.length() != 1) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getTagName(), "char", "must have a value that contains exactly 1 character!");
            }
            tableMath[ch.charAt((int)0)] = formula;
            if (tableText == null || text.equals("")) continue;
            tableText[ch.charAt((int)0)] = text;
        }
    }
}

