/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.scilab.forge.jlatexmath.core.AjLatexMath;
import org.scilab.forge.jlatexmath.core.AlphabetRegistration;
import org.scilab.forge.jlatexmath.core.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.BreakFormula;
import org.scilab.forge.jlatexmath.core.BreakMarkAtom;
import org.scilab.forge.jlatexmath.core.ColorAtom;
import org.scilab.forge.jlatexmath.core.DefaultTeXFont;
import org.scilab.forge.jlatexmath.core.DefaultTeXFontParser;
import org.scilab.forge.jlatexmath.core.EmptyAtom;
import org.scilab.forge.jlatexmath.core.FormulaNotFoundException;
import org.scilab.forge.jlatexmath.core.HorizontalBox;
import org.scilab.forge.jlatexmath.core.Insets;
import org.scilab.forge.jlatexmath.core.InvalidAtomTypeException;
import org.scilab.forge.jlatexmath.core.InvalidUnitException;
import org.scilab.forge.jlatexmath.core.MacroInfo;
import org.scilab.forge.jlatexmath.core.MatrixAtom;
import org.scilab.forge.jlatexmath.core.MiddleAtom;
import org.scilab.forge.jlatexmath.core.ParseException;
import org.scilab.forge.jlatexmath.core.PredefMacros;
import org.scilab.forge.jlatexmath.core.PredefinedCommands;
import org.scilab.forge.jlatexmath.core.PredefinedTeXFormulaParser;
import org.scilab.forge.jlatexmath.core.PredefinedTeXFormulas;
import org.scilab.forge.jlatexmath.core.ResourceParseException;
import org.scilab.forge.jlatexmath.core.RomanAtom;
import org.scilab.forge.jlatexmath.core.RowAtom;
import org.scilab.forge.jlatexmath.core.SpaceAtom;
import org.scilab.forge.jlatexmath.core.StrutBox;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;
import org.scilab.forge.jlatexmath.core.TeXFont;
import org.scilab.forge.jlatexmath.core.TeXFormulaSettingsParser;
import org.scilab.forge.jlatexmath.core.TeXIcon;
import org.scilab.forge.jlatexmath.core.TeXParser;
import org.scilab.forge.jlatexmath.core.TypedAtom;
import org.scilab.forge.jlatexmath.core.VCenteredAtom;

public class TeXFormula {
    public static final String VERSION = "1.0.3";
    public static final int SERIF = 0;
    public static final int SANSSERIF = 1;
    public static final int BOLD = 2;
    public static final int ITALIC = 4;
    public static final int ROMAN = 8;
    public static final int TYPEWRITER = 16;
    private static final String[][] delimiterNames = new String[][]{{"lbrace", "rbrace"}, {"lsqbrack", "rsqbrack"}, {"lbrack", "rbrack"}, {"downarrow", "downarrow"}, {"uparrow", "uparrow"}, {"updownarrow", "updownarrow"}, {"Downarrow", "Downarrow"}, {"Uparrow", "Uparrow"}, {"Updownarrow", "Updownarrow"}, {"vert", "vert"}, {"Vert", "Vert"}};
    public static float PIXELS_PER_POINT = 1.0f;
    private static final int OVER_DEL = 0;
    private static final int UNDER_DEL = 1;
    protected static final float PREC = 1.0E-7f;
    public static Map<String, TeXFormula> predefinedTeXFormulas = new HashMap<String, TeXFormula>(150);
    public static Map<String, String> predefinedTeXFormulasAsString = new HashMap<String, String>(150);
    public static String[] symbolMappings = new String[65536];
    public static String[] symbolTextMappings = new String[65536];
    public static String[] symbolFormulaMappings = new String[65536];
    public static Map<Character.UnicodeBlock, FontInfos> externalFontMap = new HashMap<Character.UnicodeBlock, FontInfos>();
    public List<MiddleAtom> middle = new LinkedList<MiddleAtom>();
    protected Map<String, String> jlmXMLMap;
    private TeXParser parser;
    public Atom root = null;
    public String textStyle = null;
    public boolean isColored = false;

    public static void addSymbolMappings(String file) throws ResourceParseException, IOException {
        FileInputStream in;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceParseException(file, e);
        }
        TeXFormula.addSymbolMappings(in, file);
    }

    public static void addSymbolMappings(InputStream in, String name) throws ResourceParseException, IOException {
        TeXFormulaSettingsParser tfsp = new TeXFormulaSettingsParser(in, name);
        tfsp.parseSymbolMappings(symbolMappings, symbolTextMappings);
        tfsp.parseSymbolToFormulaMappings(symbolFormulaMappings, symbolTextMappings);
    }

    public static boolean isRegisteredBlock(Character.UnicodeBlock block) {
        return externalFontMap.get(block) != null;
    }

    public static FontInfos getExternalFont(Character.UnicodeBlock block) {
        FontInfos infos = externalFontMap.get(block);
        if (infos == null) {
            infos = new FontInfos("SansSerif", "Serif");
            externalFontMap.put(block, infos);
        }
        return infos;
    }

    public static void registerExternalFont(Character.UnicodeBlock block, String sansserif, String serif) {
        if (sansserif == null && serif == null) {
            externalFontMap.remove(block);
            return;
        }
        externalFontMap.put(block, new FontInfos(sansserif, serif));
        if (block.equals(Character.UnicodeBlock.BASIC_LATIN)) {
            predefinedTeXFormulas.clear();
        }
    }

    public static void registerExternalFont(Character.UnicodeBlock block, String fontName) {
        TeXFormula.registerExternalFont(block, fontName, fontName);
    }

    public static void setDPITarget(float dpi) {
        PIXELS_PER_POINT = dpi / 72.0f;
    }

    public static void setDefaultDPI() {
        TeXFormula.setDPITarget(AjLatexMath.getContext().getResources().getDisplayMetrics().xdpi);
    }

    public TeXFormula() {
        this.parser = new TeXParser("", this, false);
    }

    public TeXFormula(String s, Map<String, String> map) throws ParseException {
        this.jlmXMLMap = map;
        this.textStyle = this.textStyle;
        this.parser = new TeXParser(s, this);
        this.parser.parse();
    }

    public TeXFormula(String s) throws ParseException {
        this(s, (String)null);
    }

    public TeXFormula(String s, boolean firstpass) throws ParseException {
        this.textStyle = null;
        this.parser = new TeXParser(s, this, firstpass);
        this.parser.parse();
    }

    public TeXFormula(String s, String textStyle) throws ParseException {
        this.textStyle = textStyle;
        this.parser = new TeXParser(s, this);
        this.parser.parse();
    }

    public TeXFormula(String s, String textStyle, boolean firstpass, boolean space) throws ParseException {
        this.textStyle = textStyle;
        this.parser = new TeXParser(s, this, firstpass, space);
        this.parser.parse();
    }

    public TeXFormula(TeXFormula f) {
        if (f != null) {
            this.addImpl(f);
        }
    }

    protected TeXFormula(TeXParser tp) {
        this.jlmXMLMap = tp.formula.jlmXMLMap;
        this.parser = new TeXParser(tp.getIsPartial(), "", this, false);
    }

    protected TeXFormula(TeXParser tp, String s) throws ParseException {
        this(tp, s, null);
    }

    protected TeXFormula(TeXParser tp, String s, boolean firstpass) throws ParseException {
        this.textStyle = null;
        this.jlmXMLMap = tp.formula.jlmXMLMap;
        boolean isPartial = tp.getIsPartial();
        this.parser = new TeXParser(isPartial, s, this, firstpass);
        if (isPartial) {
            try {
                this.parser.parse();
            }
            catch (Exception exception) {}
        } else {
            this.parser.parse();
        }
    }

    protected TeXFormula(TeXParser tp, String s, String textStyle) throws ParseException {
        this.textStyle = textStyle;
        this.jlmXMLMap = tp.formula.jlmXMLMap;
        boolean isPartial = tp.getIsPartial();
        this.parser = new TeXParser(isPartial, s, this);
        if (isPartial) {
            try {
                this.parser.parse();
            }
            catch (Exception e) {
                if (this.root == null) {
                    this.root = new EmptyAtom();
                }
            }
        } else {
            this.parser.parse();
        }
    }

    protected TeXFormula(TeXParser tp, String s, String textStyle, boolean firstpass, boolean space) throws ParseException {
        this.textStyle = textStyle;
        this.jlmXMLMap = tp.formula.jlmXMLMap;
        boolean isPartial = tp.getIsPartial();
        this.parser = new TeXParser(isPartial, s, this, firstpass, space);
        if (isPartial) {
            try {
                this.parser.parse();
            }
            catch (Exception e) {
                if (this.root == null) {
                    this.root = new EmptyAtom();
                }
            }
        } else {
            this.parser.parse();
        }
    }

    public static TeXFormula getAsText(String text, int alignment) throws ParseException {
        TeXFormula formula = new TeXFormula();
        if (text == null || "".equals(text)) {
            formula.add(new EmptyAtom());
            return formula;
        }
        String[] arr = text.split("\n|\\\\\\\\|\\\\cr");
        ArrayOfAtoms atoms = new ArrayOfAtoms();
        for (String s : arr) {
            TeXFormula f = new TeXFormula(s, "mathnormal", true, false);
            atoms.add(new RomanAtom(f.root));
            atoms.addRow();
        }
        atoms.checkDimensions();
        formula.add(new MatrixAtom(false, atoms, 0, alignment));
        return formula;
    }

    public static TeXFormula getPartialTeXFormula(String formula) {
        TeXFormula f;
        block3: {
            f = new TeXFormula();
            if (formula == null) {
                f.add(new EmptyAtom());
                return f;
            }
            TeXParser parser = new TeXParser(true, formula, f);
            try {
                parser.parse();
            }
            catch (Exception e) {
                if (f.root != null) break block3;
                f.root = new EmptyAtom();
            }
        }
        return f;
    }

    public static void registerFonts(boolean b) {
        DefaultTeXFontParser.registerFonts(b);
    }

    public void setLaTeX(String ltx) throws ParseException {
        this.parser.reset(ltx);
        if (ltx != null && ltx.length() != 0) {
            this.parser.parse();
        }
    }

    public TeXFormula add(Atom el) {
        if (el != null) {
            if (el instanceof MiddleAtom) {
                this.middle.add((MiddleAtom)el);
            }
            if (this.root == null) {
                this.root = el;
            } else {
                TypedAtom ta;
                int rtype;
                if (!(this.root instanceof RowAtom)) {
                    this.root = new RowAtom(this.root);
                }
                ((RowAtom)this.root).add(el);
                if (el instanceof TypedAtom && ((rtype = (ta = (TypedAtom)el).getRightType()) == 2 || rtype == 3)) {
                    ((RowAtom)this.root).add(new BreakMarkAtom());
                }
            }
        }
        return this;
    }

    public TeXFormula add(String s) throws ParseException {
        if (s != null && s.length() != 0) {
            this.textStyle = null;
            this.add(new TeXFormula(s));
        }
        return this;
    }

    public TeXFormula append(String s) throws ParseException {
        return this.append(false, s);
    }

    public TeXFormula append(boolean isPartial, String s) throws ParseException {
        if (s != null && s.length() != 0) {
            TeXParser tp = new TeXParser(isPartial, s, this);
            tp.parse();
        }
        return this;
    }

    public TeXFormula add(TeXFormula f) {
        this.addImpl(f);
        return this;
    }

    private void addImpl(TeXFormula f) {
        if (f.root != null) {
            if (f.root instanceof RowAtom) {
                this.add(new RowAtom(f.root));
            } else {
                this.add(f.root);
            }
        }
    }

    public void setLookAtLastAtom(boolean b) {
        if (this.root instanceof RowAtom) {
            ((RowAtom)this.root).lookAtLastAtom = b;
        }
    }

    public boolean getLookAtLastAtom() {
        if (this.root instanceof RowAtom) {
            return ((RowAtom)this.root).lookAtLastAtom;
        }
        return false;
    }

    public TeXFormula centerOnAxis() {
        this.root = new VCenteredAtom(this.root);
        return this;
    }

    public static void addPredefinedTeXFormula(InputStream xmlFile) throws ResourceParseException, IOException {
        new PredefinedTeXFormulaParser(xmlFile, "TeXFormula").parse(predefinedTeXFormulas);
    }

    public static void addPredefinedCommands(InputStream xmlFile) throws ResourceParseException, IOException {
        new PredefinedTeXFormulaParser(xmlFile, "Command").parse(MacroInfo.Commands);
    }

    public TeXFormula addStrut(int unit, float width, float height, float depth) throws InvalidUnitException {
        return this.add(new SpaceAtom(unit, width, height, depth));
    }

    public TeXFormula addStrut(int type) throws InvalidUnitException {
        return this.add(new SpaceAtom(type));
    }

    public TeXFormula addStrut(int widthUnit, float width, int heightUnit, float height, int depthUnit, float depth) throws InvalidUnitException {
        return this.add(new SpaceAtom(widthUnit, width, heightUnit, height, depthUnit, depth));
    }

    private Box createBox(TeXEnvironment style) {
        if (this.root == null) {
            return new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.root.createBox(style);
    }

    private DefaultTeXFont createFont(float size, int type) {
        DefaultTeXFont dtf = new DefaultTeXFont(size);
        if (type == 0) {
            dtf.setSs(false);
        }
        if ((type & 8) != 0) {
            dtf.setRoman(true);
        }
        if ((type & 0x10) != 0) {
            dtf.setTt(true);
        }
        if ((type & 1) != 0) {
            dtf.setSs(true);
        }
        if ((type & 4) != 0) {
            dtf.setIt(true);
        }
        if ((type & 2) != 0) {
            dtf.setBold(true);
        }
        return dtf;
    }

    public TeXIcon createTeXIcon(int style, float size) {
        return new TeXIconBuilder().setStyle(style).setSize(size).build();
    }

    public TeXIcon createTeXIcon(int style, float size, int type) {
        return new TeXIconBuilder().setStyle(style).setSize(size).setType(type).build();
    }

    public TeXIcon createTeXIcon(int style, float size, int type, Integer fgcolor) {
        return new TeXIconBuilder().setStyle(style).setSize(size).setType(type).setFGColor(fgcolor).build();
    }

    public TeXIcon createTeXIcon(int style, float size, boolean trueValues) {
        return new TeXIconBuilder().setStyle(style).setSize(size).setTrueValues(trueValues).build();
    }

    public TeXIcon createTeXIcon(int style, float size, int widthUnit, float textwidth, int align) {
        return this.createTeXIcon(style, size, 0, widthUnit, textwidth, align);
    }

    public TeXIcon createTeXIcon(int style, float size, int type, int widthUnit, float textwidth, int align) {
        return new TeXIconBuilder().setStyle(style).setSize(size).setType(type).setWidth(widthUnit, textwidth, align).build();
    }

    public TeXIcon createTeXIcon(int style, float size, int widthUnit, float textwidth, int align, int interlineUnit, float interline) {
        return this.createTeXIcon(style, size, 0, widthUnit, textwidth, align, interlineUnit, interline);
    }

    public TeXIcon createTeXIcon(int style, float size, int type, int widthUnit, float textwidth, int align, int interlineUnit, float interline) {
        return new TeXIconBuilder().setStyle(style).setSize(size).setType(type).setWidth(widthUnit, textwidth, align).setInterLineSpacing(interlineUnit, interline).build();
    }

    public void createImage(Bitmap.CompressFormat format, int style, float size, String out, Integer bg, Integer fg, boolean transparency) throws IOException {
        TeXIcon icon = this.createTeXIcon(style, size);
        icon.setInsets(new Insets(1, 1, 1, 1));
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        Bitmap image = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas g2 = new Canvas(image);
        if (bg != null) {
            Paint st = new Paint();
            st.setStyle(Paint.Style.FILL_AND_STROKE);
            st.setColor(bg.intValue());
            g2.drawRect(0.0f, 0.0f, (float)w, (float)h, st);
        }
        icon.setForeground(fg == null ? -16777216 : fg);
        icon.paintIcon(g2, 0, 0);
        File file = new File(out);
        FileOutputStream imout = new FileOutputStream(file);
        image.compress(format, 90, (OutputStream)imout);
        imout.flush();
        imout.close();
    }

    public void createPNG(int style, float size, String out, Integer bg, Integer fg) throws IOException {
        this.createImage(Bitmap.CompressFormat.PNG, style, size, out, bg, fg, bg == null);
    }

    @SuppressLint(value={"NewApi"})
    public void createWEBP(int style, float size, String out, Integer bg, Integer fg) throws IOException {
        this.createImage(Bitmap.CompressFormat.WEBP, style, size, out, bg, fg, bg == null);
    }

    public void createJPEG(int style, float size, String out, Integer bg, Integer fg) throws IOException {
        this.createImage(Bitmap.CompressFormat.JPEG, style, size, out, bg, fg, false);
    }

    public static Bitmap createBufferedImage(String formula, int style, float size, Integer fg, Integer bg) throws ParseException {
        TeXFormula f = new TeXFormula(formula);
        TeXIcon icon = f.createTeXIcon(style, size);
        icon.setInsets(new Insets(2, 2, 2, 2));
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        Bitmap image = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas g2 = new Canvas(image);
        if (bg != null) {
            Paint st = new Paint();
            st.setStyle(Paint.Style.FILL_AND_STROKE);
            st.setColor(bg.intValue());
            g2.drawRect(0.0f, 0.0f, (float)w, (float)h, st);
        }
        icon.setForeground(fg == null ? -16777216 : fg);
        icon.paintIcon(g2, 0, 0);
        return image;
    }

    public Bitmap createBufferedImage(int style, float size, Integer fg, Integer bg) throws ParseException {
        TeXIcon icon = this.createTeXIcon(style, size);
        icon.setInsets(new Insets(2, 2, 2, 2));
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        Bitmap image = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas g2 = new Canvas(image);
        if (bg != null) {
            Paint st = new Paint();
            st.setStyle(Paint.Style.FILL_AND_STROKE);
            st.setColor(bg.intValue());
            g2.drawRect(0.0f, 0.0f, (float)w, (float)h, st);
        }
        icon.setForeground(fg == null ? -16777216 : fg);
        icon.paintIcon(g2, 0, 0);
        return image;
    }

    public void setDEBUG(boolean b) {
        Box.DEBUG = b;
    }

    public TeXFormula setBackground(Integer c) {
        if (c != null) {
            this.root = this.root instanceof ColorAtom ? new ColorAtom(c, null, (ColorAtom)this.root) : new ColorAtom(this.root, c, null);
        }
        return this;
    }

    public TeXFormula setColor(Integer c) {
        if (c != null) {
            this.root = this.root instanceof ColorAtom ? new ColorAtom(null, c, (ColorAtom)this.root) : new ColorAtom(this.root, null, c);
        }
        return this;
    }

    public TeXFormula setFixedTypes(int leftType, int rightType) throws InvalidAtomTypeException {
        this.root = new TypedAtom(leftType, rightType, this.root);
        return this;
    }

    public static TeXFormula get(String name) throws FormulaNotFoundException {
        TeXFormula formula = predefinedTeXFormulas.get(name);
        if (formula == null) {
            String f = predefinedTeXFormulasAsString.get(name);
            if (f == null) {
                throw new FormulaNotFoundException(name);
            }
            TeXFormula tf = new TeXFormula(f);
            predefinedTeXFormulas.put(name, tf);
            return tf;
        }
        return new TeXFormula(formula);
    }

    static {
        TeXFormulaSettingsParser parser = null;
        try {
            parser = new TeXFormulaSettingsParser();
        }
        catch (IOException | ResourceParseException e1) {
            e1.printStackTrace();
        }
        parser.parseSymbolMappings(symbolMappings, symbolTextMappings);
        new PredefinedCommands();
        new PredefinedTeXFormulas();
        new PredefMacros();
        parser.parseSymbolToFormulaMappings(symbolFormulaMappings, symbolTextMappings);
        try {
            DefaultTeXFont.registerAlphabet((AlphabetRegistration)Class.forName("org.scilab.forge.jlatexmath.cyrillic.CyrillicRegistration").newInstance());
            DefaultTeXFont.registerAlphabet((AlphabetRegistration)Class.forName("org.scilab.forge.jlatexmath.greek.GreekRegistration").newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TeXFormula.setDefaultDPI();
    }

    static class FontInfos {
        String sansserif;
        String serif;

        FontInfos(String sansserif, String serif) {
            this.sansserif = sansserif;
            this.serif = serif;
        }
    }

    public class TeXIconBuilder {
        private Integer style;
        private Float size;
        private Integer type;
        private Integer fgcolor;
        private boolean trueValues = false;
        private Integer widthUnit;
        private Float textWidth;
        private Integer align;
        private boolean isMaxWidth = false;
        private Integer interLineUnit;
        private Float interLineSpacing;

        public TeXIconBuilder setStyle(int style) {
            this.style = style;
            return this;
        }

        public TeXIconBuilder setSize(float size) {
            this.size = Float.valueOf(TypedValue.applyDimension((int)2, (float)(size / PIXELS_PER_POINT), (DisplayMetrics)AjLatexMath.getContext().getResources().getDisplayMetrics()));
            return this;
        }

        public TeXIconBuilder setType(int type) {
            this.type = type;
            return this;
        }

        public TeXIconBuilder setFGColor(Integer fgcolor) {
            this.fgcolor = fgcolor;
            return this;
        }

        public TeXIconBuilder setTrueValues(boolean trueValues) {
            this.trueValues = trueValues;
            return this;
        }

        public TeXIconBuilder setWidth(int widthUnit, float textWidth, int align) {
            this.widthUnit = widthUnit;
            this.textWidth = Float.valueOf(textWidth);
            this.align = align;
            this.trueValues = true;
            return this;
        }

        public TeXIconBuilder setIsMaxWidth(boolean isMaxWidth) {
            if (this.widthUnit == null) {
                throw new IllegalStateException("Cannot set 'isMaxWidth' without having specified a width!");
            }
            if (isMaxWidth) {
                this.align = 0;
            }
            this.isMaxWidth = isMaxWidth;
            return this;
        }

        public TeXIconBuilder setInterLineSpacing(int interLineUnit, float interLineSpacing) {
            if (this.widthUnit == null) {
                throw new IllegalStateException("Cannot set inter line spacing without having specified a width!");
            }
            this.interLineUnit = interLineUnit;
            this.interLineSpacing = Float.valueOf(interLineSpacing);
            return this;
        }

        public TeXIcon build() {
            TeXIcon ti;
            if (this.style == null) {
                throw new IllegalStateException("A style is required. Use setStyle()");
            }
            if (this.size == null) {
                throw new IllegalStateException("A size is required. Use setStyle()");
            }
            DefaultTeXFont font = this.type == null ? new DefaultTeXFont(this.size.floatValue()) : TeXFormula.this.createFont(this.size.floatValue(), this.type);
            TeXEnvironment te = this.widthUnit != null ? new TeXEnvironment((int)this.style, (TeXFont)font, (int)this.widthUnit, this.textWidth.floatValue()) : new TeXEnvironment(this.style, font);
            if (this.interLineUnit != null) {
                te.setInterline(this.interLineUnit, this.interLineSpacing.floatValue());
            }
            Box box = TeXFormula.this.createBox(te);
            if (this.widthUnit != null) {
                HorizontalBox hb;
                if (this.interLineUnit != null) {
                    float il = this.interLineSpacing.floatValue() * SpaceAtom.getFactor(this.interLineUnit, te);
                    Box b = BreakFormula.split(box, te.getTextwidth(), il);
                    hb = new HorizontalBox(b, this.isMaxWidth ? b.getWidth() : te.getTextwidth(), this.align);
                } else {
                    hb = new HorizontalBox(box, this.isMaxWidth ? box.getWidth() : te.getTextwidth(), this.align);
                }
                ti = new TeXIcon(hb, this.size.floatValue(), this.trueValues);
            } else {
                ti = new TeXIcon(box, this.size.floatValue(), this.trueValues);
            }
            if (this.fgcolor != null) {
                ti.setForeground(this.fgcolor);
            }
            ti.isColored = te.isColored;
            return ti;
        }
    }
}

