/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.Char;
import org.scilab.forge.jlatexmath.core.CharBox;
import org.scilab.forge.jlatexmath.core.HorizontalBox;
import org.scilab.forge.jlatexmath.core.StrutBox;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;
import org.scilab.forge.jlatexmath.core.VerticalBox;

public class TStrokeAtom
extends Atom {
    private boolean upper;

    public TStrokeAtom(boolean upper) {
        this.upper = upper;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        Box y;
        Char ch = env.getTeXFont().getChar("bar", env.getStyle());
        float italic = ch.getItalic();
        CharBox T = new CharBox(env.getTeXFont().getChar(this.upper ? (char)'T' : 't', "mathnormal", env.getStyle()));
        CharBox B = new CharBox(ch);
        if (Math.abs(italic) > 1.0E-7f) {
            y = new HorizontalBox(new StrutBox(-italic, 0.0f, 0.0f, 0.0f));
            y.add(B);
        } else {
            y = B;
        }
        HorizontalBox b = new HorizontalBox(y, T.getWidth(), 2);
        VerticalBox vb = new VerticalBox();
        vb.add(T);
        vb.add(new StrutBox(0.0f, -0.5f * T.getHeight(), 0.0f, 0.0f));
        vb.add(b);
        return vb;
    }
}

