/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.scilab.forge.jlatexmath.core.AjLatexMath;
import org.scilab.forge.jlatexmath.core.FramedBox;

public class ShadowBox
extends FramedBox {
    private float shadowRule;

    public ShadowBox(FramedBox fbox, float shadowRule) {
        super(fbox.box, fbox.thickness, fbox.space);
        this.shadowRule = shadowRule;
        this.depth += shadowRule;
        this.width += shadowRule;
    }

    @Override
    public void draw(Canvas g2, float x, float y) {
        float th = this.thickness / 2.0f;
        this.box.draw(g2, x + this.space + this.thickness, y);
        Paint st = AjLatexMath.getPaint();
        float w = st.getStrokeWidth();
        int c = st.getColor();
        Paint.Style s = st.getStyle();
        st.setStrokeWidth(this.thickness);
        st.setStyle(Paint.Style.STROKE);
        float penth = 0.0f;
        g2.drawRect(x + th, y - this.height + th, x + th + this.width - this.shadowRule - this.thickness, y + th + this.depth - this.shadowRule - this.thickness, st);
        st.setStyle(Paint.Style.FILL);
        g2.drawRect(x + this.shadowRule - penth, y + this.depth - this.shadowRule - penth, x - penth + this.width, y + this.depth - penth, st);
        g2.drawRect(x + this.width - this.shadowRule - penth, y - this.height + th + this.shadowRule, x + this.width - penth, y + this.shadowRule + this.depth - 2.0f * this.shadowRule, st);
        st.setColor(c);
        st.setStrokeWidth(w);
        st.setStyle(s);
        st.clearShadowLayer();
    }

    @Override
    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

