/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.DelimiterFactory;
import org.scilab.forge.jlatexmath.core.EmptyAtom;
import org.scilab.forge.jlatexmath.core.HorizontalBox;
import org.scilab.forge.jlatexmath.core.OverBar;
import org.scilab.forge.jlatexmath.core.SpaceAtom;
import org.scilab.forge.jlatexmath.core.StrutBox;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;
import org.scilab.forge.jlatexmath.core.TeXFont;

public class NthRoot
extends Atom {
    private static final String sqrtSymbol = "sqrt";
    private static final float FACTOR = 0.55f;
    private final Atom base;
    private final Atom root;

    public NthRoot(Atom base, Atom root) {
        this.base = base == null ? new EmptyAtom() : base;
        this.root = root == null ? new EmptyAtom() : root;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        float drt = tf.getDefaultRuleThickness(style);
        float clr = style < 2 ? tf.getXHeight(style, tf.getChar(sqrtSymbol, style).getFontCode()) : drt;
        clr = drt + Math.abs(clr) / 4.0f;
        Box bs = this.base.createBox(env.crampStyle());
        HorizontalBox b = new HorizontalBox(bs);
        b.add(new SpaceAtom(5, 1.0f, 0.0f, 0.0f).createBox(env.crampStyle()));
        float totalH = b.getHeight() + b.getDepth();
        Box rootSign = DelimiterFactory.create(sqrtSymbol, env, totalH + clr + drt);
        float delta = rootSign.getDepth() - (totalH + clr);
        rootSign.setShift(-(b.getHeight() + (clr += delta / 2.0f)));
        OverBar ob = new OverBar((Box)b, clr, rootSign.getHeight());
        ob.setShift(-(b.getHeight() + clr + drt));
        HorizontalBox squareRoot = new HorizontalBox(rootSign);
        squareRoot.add(ob);
        if (this.root == null) {
            return squareRoot;
        }
        Box r = this.root.createBox(env.rootStyle());
        float bottomShift = 0.55f * (squareRoot.getHeight() + squareRoot.getDepth());
        r.setShift(squareRoot.getDepth() - r.getDepth() - bottomShift);
        Box negativeKern = new SpaceAtom(5, -10.0f, 0.0f, 0.0f).createBox(env);
        HorizontalBox res = new HorizontalBox();
        float pos = r.getWidth() + negativeKern.getWidth();
        if (pos < 0.0f) {
            ((Box)res).add(new StrutBox(-pos, 0.0f, 0.0f, 0.0f));
        }
        ((Box)res).add(r);
        ((Box)res).add(negativeKern);
        ((Box)res).add(squareRoot);
        return res;
    }
}

