/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Typeface;
import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.DefaultTeXFont;
import org.scilab.forge.jlatexmath.core.JavaFontRenderingBox;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;
import org.scilab.forge.jlatexmath.core.TeXFormula;

public class JavaFontRenderingAtom
extends Atom {
    private String str;
    private int type;
    private TeXFormula.FontInfos fontInfos;

    public JavaFontRenderingAtom(String str, int type) {
        this.str = str;
        this.type = type;
    }

    public JavaFontRenderingAtom(String str, TeXFormula.FontInfos fontInfos) {
        this(str, 0);
        this.fontInfos = fontInfos;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        if (this.fontInfos == null) {
            return new JavaFontRenderingBox(this.str, this.type, DefaultTeXFont.getSizeFactor(env.getStyle()));
        }
        DefaultTeXFont dtf = (DefaultTeXFont)env.getTeXFont();
        int type = dtf.isIt ? 2 : 0;
        boolean kerning = dtf.isRoman;
        Typeface font = dtf.isSs ? (this.fontInfos.sansserif == null ? Typeface.SERIF : Typeface.SANS_SERIF) : (this.fontInfos.serif == null ? Typeface.SANS_SERIF : Typeface.SERIF);
        return new JavaFontRenderingBox(this.str, type |= dtf.isBold ? 1 : 0, DefaultTeXFont.getSizeFactor(env.getStyle()), font, kerning);
    }
}

