/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.GlueBox;
import org.scilab.forge.jlatexmath.core.GlueSettingsParser;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;
import org.scilab.forge.jlatexmath.core.TeXFont;

public class Glue {
    private final float space;
    private final float stretch;
    private final float shrink;
    private final String name;
    private static Glue[] glueTypes;
    private static final int[][][] glueTable;

    public Glue(float space, float stretch, float shrink, String name) {
        this.space = space;
        this.stretch = stretch;
        this.shrink = shrink;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Box get(int lType, int rType, TeXEnvironment env) {
        int l = lType > 7 ? 0 : lType;
        int r = rType > 7 ? 0 : rType;
        int glueType = glueTable[l][r][env.getStyle() / 2];
        return glueTypes[glueType].createBox(env);
    }

    private Box createBox(TeXEnvironment env) {
        TeXFont tf = env.getTeXFont();
        float quad = tf.getQuad(env.getStyle(), tf.getMuFontId());
        return new GlueBox(this.space / 18.0f * quad, this.stretch / 18.0f * quad, this.shrink / 18.0f * quad);
    }

    static {
        GlueSettingsParser parser = new GlueSettingsParser();
        glueTypes = parser.getGlueTypes();
        glueTable = parser.createGlueTable();
    }
}

