/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import org.scilab.forge.jlatexmath.core.AjLatexMath;
import org.scilab.forge.jlatexmath.core.Box;

public class GeoGebraLogoBox
extends Box {
    private static final Integer gray = Color.rgb((int)102, (int)102, (int)102);
    private static final Integer blue = Color.rgb((int)153, (int)153, (int)255);

    public GeoGebraLogoBox(float w, float h) {
        this.depth = 0.0f;
        this.height = h;
        this.width = w;
        this.shift = 0.0f;
    }

    @Override
    public void draw(Canvas g2, float x, float y) {
        g2.save();
        Paint st = AjLatexMath.getPaint();
        int c = st.getColor();
        Paint.Style s = st.getStyle();
        float w = st.getStrokeWidth();
        g2.translate(x + 0.25f * this.height / 2.15f, y - 0.81395346f * this.height);
        st.setColor(gray.intValue());
        st.setStrokeWidth(3.8f);
        g2.scale(0.05f * this.height / 2.15f, 0.05f * this.height / 2.15f);
        g2.rotate((float)Math.toDegrees(-0.4537856055185257), 20.5f, 17.5f);
        g2.drawArc(new RectF(0.0f, 0.0f, 43.0f, 32.0f), 0.0f, 360.0f, false, st);
        g2.rotate((float)Math.toDegrees(0.4537856055185257), 20.5f, 17.5f);
        st.setStyle(Paint.Style.STROKE);
        GeoGebraLogoBox.drawCircle(st, g2, 16.0f, -5.0f);
        GeoGebraLogoBox.drawCircle(st, g2, -1.0f, 7.0f);
        GeoGebraLogoBox.drawCircle(st, g2, 5.0f, 28.0f);
        GeoGebraLogoBox.drawCircle(st, g2, 27.0f, 24.0f);
        GeoGebraLogoBox.drawCircle(st, g2, 36.0f, 3.0f);
        st.setColor(c);
        st.setStyle(s);
        st.setStrokeWidth(w);
        g2.restore();
    }

    private static void drawCircle(Paint st, Canvas g2, float x, float y) {
        st.setColor(blue.intValue());
        g2.translate(x, y);
        g2.drawCircle(0.0f, 0.0f, 8.0f, st);
        st.setColor(-16777216);
        st.setStyle(Paint.Style.STROKE);
        g2.drawCircle(0.0f, 0.0f, 8.0f, st);
        g2.translate(-x, -y);
    }

    @Override
    public int getLastFontId() {
        return 0;
    }
}

