/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.scilab.forge.jlatexmath.core.AjLatexMath;
import org.scilab.forge.jlatexmath.core.Box;

public class FcscoreBox
extends Box {
    private int N;
    private boolean strike;
    private float space;
    private float thickness;

    public FcscoreBox(int N, float h, float thickness, float space, boolean strike) {
        this.N = N;
        this.width = (float)N * (thickness + space) + 2.0f * space;
        this.height = h;
        this.depth = 0.0f;
        this.strike = strike;
        this.space = space;
        this.thickness = thickness;
    }

    @Override
    public void draw(Canvas g2, float x, float y) {
        Paint st = AjLatexMath.getPaint();
        float s = 1.0f;
        float w = st.getStrokeWidth();
        Paint.Style ss = st.getStyle();
        st.setStrokeWidth(s * this.thickness);
        st.setStyle(Paint.Style.STROKE);
        float th = this.thickness / 2.0f;
        float xx = x + this.space;
        xx = xx * s + this.space / 2.0f * s;
        int inc = Math.round((this.space + this.thickness) * s);
        for (int i = 0; i < this.N; ++i) {
            g2.drawLine(xx + th * s, (y - this.height) * s, xx + th * s, y * s, st);
            xx += (float)inc;
        }
        if (this.strike) {
            g2.drawLine((x + this.space) * s, (y - this.height / 2.0f) * s, xx - s * this.space / 2.0f, (y - this.height / 2.0f) * s, st);
        }
        st.setStrokeWidth(w);
        st.setStyle(ss);
    }

    @Override
    public int getLastFontId() {
        return -1;
    }
}

