/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.Dummy;
import org.scilab.forge.jlatexmath.core.Row;
import org.scilab.forge.jlatexmath.core.RowAtom;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;

public class ColorAtom
extends Atom
implements Row {
    public static Map<String, Integer> Colors = new HashMap<String, Integer>();
    private final Integer background;
    private final Integer color;
    private final RowAtom elements;

    public ColorAtom(Atom atom, Integer bg, Integer i) {
        this.elements = new RowAtom(atom);
        this.background = bg;
        this.color = i;
    }

    public ColorAtom(Integer bg, Integer c, ColorAtom old) {
        this.elements = new RowAtom(old.elements);
        this.background = bg == null ? old.background : bg;
        this.color = c == null ? old.color : c;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        env.isColored = true;
        TeXEnvironment copy = env.copy();
        if (this.background != null) {
            copy.setBackground(this.background);
        }
        if (this.color != null) {
            copy.setColor(this.color);
        }
        return this.elements.createBox(copy);
    }

    @Override
    public int getLeftType() {
        return this.elements.getLeftType();
    }

    @Override
    public int getRightType() {
        return this.elements.getRightType();
    }

    @Override
    public void setPreviousAtom(Dummy prev) {
        this.elements.setPreviousAtom(prev);
    }

    public static int getColor(String s) {
        if (s != null && s.length() != 0) {
            Integer c;
            if ((s = s.trim()).charAt(0) == '#') {
                return Color.parseColor((String)s);
            }
            if (s.indexOf(44) != -1) {
                StringTokenizer toks = new StringTokenizer(s, ";,");
                int n = toks.countTokens();
                if (n == 3) {
                    try {
                        String R2 = toks.nextToken().trim();
                        String G = toks.nextToken().trim();
                        String B = toks.nextToken().trim();
                        float r = Float.parseFloat(R2);
                        float g = Float.parseFloat(G);
                        float b = Float.parseFloat(B);
                        if (r == (float)((int)r) && g == (float)((int)g) && b == (float)((int)b) && R2.indexOf(46) == -1 && G.indexOf(46) == -1 && B.indexOf(46) == -1) {
                            int ir = (int)Math.min(255.0f, Math.max(0.0f, r));
                            int ig = (int)Math.min(255.0f, Math.max(0.0f, g));
                            int ib = (int)Math.min(255.0f, Math.max(0.0f, b));
                            return Color.rgb((int)ir, (int)ig, (int)ib);
                        }
                        r = Math.min(1.0f, Math.max(0.0f, r));
                        g = Math.min(1.0f, Math.max(0.0f, g));
                        b = Math.min(1.0f, Math.max(0.0f, b));
                        return Color.rgb((int)((int)r), (int)((int)g), (int)((int)b));
                    }
                    catch (NumberFormatException e) {
                        return -16777216;
                    }
                }
                if (n == 4) {
                    try {
                        float c2 = Float.parseFloat(toks.nextToken().trim());
                        float m = Float.parseFloat(toks.nextToken().trim());
                        float y = Float.parseFloat(toks.nextToken().trim());
                        float k = Float.parseFloat(toks.nextToken().trim());
                        c2 = Math.min(1.0f, Math.max(0.0f, c2));
                        m = Math.min(1.0f, Math.max(0.0f, m));
                        y = Math.min(1.0f, Math.max(0.0f, y));
                        k = Math.min(1.0f, Math.max(0.0f, k));
                        return ColorAtom.convColor(c2, m, y, k);
                    }
                    catch (NumberFormatException e) {
                        return -16777216;
                    }
                }
            }
            if ((c = Colors.get(s.toLowerCase())) != null) {
                return c;
            }
            if (s.indexOf(46) != -1) {
                try {
                    float g = Math.min(1.0f, Math.max(Float.parseFloat(s), 0.0f));
                    return Color.rgb((int)((int)g), (int)((int)g), (int)((int)g));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return Color.parseColor((String)("#" + s));
        }
        return -16777216;
    }

    private static void initColors() {
        Colors.put("black", -16777216);
        Colors.put("white", -1);
        Colors.put("red", -65536);
        Colors.put("green", -16711936);
        Colors.put("blue", -16776961);
        Colors.put("cyan", -16711681);
        Colors.put("magenta", -65281);
        Colors.put("yellow", -256);
        Colors.put("greenyellow", ColorAtom.convColor(0.15f, 0.0f, 0.69f, 0.0f));
        Colors.put("goldenrod", ColorAtom.convColor(0.0f, 0.1f, 0.84f, 0.0f));
        Colors.put("dandelion", ColorAtom.convColor(0.0f, 0.29f, 0.84f, 0.0f));
        Colors.put("apricot", ColorAtom.convColor(0.0f, 0.32f, 0.52f, 0.0f));
        Colors.put("peach", ColorAtom.convColor(0.0f, 0.5f, 0.7f, 0.0f));
        Colors.put("melon", ColorAtom.convColor(0.0f, 0.46f, 0.5f, 0.0f));
        Colors.put("yelloworange", ColorAtom.convColor(0.0f, 0.42f, 1.0f, 0.0f));
        Colors.put("orange", ColorAtom.convColor(0.0f, 0.61f, 0.87f, 0.0f));
        Colors.put("burntorange", ColorAtom.convColor(0.0f, 0.51f, 1.0f, 0.0f));
        Colors.put("bittersweet", ColorAtom.convColor(0.0f, 0.75f, 1.0f, 0.24f));
        Colors.put("redorange", ColorAtom.convColor(0.0f, 0.77f, 0.87f, 0.0f));
        Colors.put("mahogany", ColorAtom.convColor(0.0f, 0.85f, 0.87f, 0.35f));
        Colors.put("maroon", ColorAtom.convColor(0.0f, 0.87f, 0.68f, 0.32f));
        Colors.put("brickred", ColorAtom.convColor(0.0f, 0.89f, 0.94f, 0.28f));
        Colors.put("orangered", ColorAtom.convColor(0.0f, 1.0f, 0.5f, 0.0f));
        Colors.put("rubinered", ColorAtom.convColor(0.0f, 1.0f, 0.13f, 0.0f));
        Colors.put("wildstrawberry", ColorAtom.convColor(0.0f, 0.96f, 0.39f, 0.0f));
        Colors.put("salmon", ColorAtom.convColor(0.0f, 0.53f, 0.38f, 0.0f));
        Colors.put("carnationpink", ColorAtom.convColor(0.0f, 0.63f, 0.0f, 0.0f));
        Colors.put("magenta", ColorAtom.convColor(0.0f, 1.0f, 0.0f, 0.0f));
        Colors.put("violetred", ColorAtom.convColor(0.0f, 0.81f, 0.0f, 0.0f));
        Colors.put("rhodamine", ColorAtom.convColor(0.0f, 0.82f, 0.0f, 0.0f));
        Colors.put("mulberry", ColorAtom.convColor(0.34f, 0.9f, 0.0f, 0.02f));
        Colors.put("redviolet", ColorAtom.convColor(0.07f, 0.9f, 0.0f, 0.34f));
        Colors.put("fuchsia", ColorAtom.convColor(0.47f, 0.91f, 0.0f, 0.08f));
        Colors.put("lavender", ColorAtom.convColor(0.0f, 0.48f, 0.0f, 0.0f));
        Colors.put("thistle", ColorAtom.convColor(0.12f, 0.59f, 0.0f, 0.0f));
        Colors.put("orchid", ColorAtom.convColor(0.32f, 0.64f, 0.0f, 0.0f));
        Colors.put("darkorchid", ColorAtom.convColor(0.4f, 0.8f, 0.2f, 0.0f));
        Colors.put("purple", ColorAtom.convColor(0.45f, 0.86f, 0.0f, 0.0f));
        Colors.put("plum", ColorAtom.convColor(0.5f, 1.0f, 0.0f, 0.0f));
        Colors.put("violet", ColorAtom.convColor(0.79f, 0.88f, 0.0f, 0.0f));
        Colors.put("royalpurple", ColorAtom.convColor(0.75f, 0.9f, 0.0f, 0.0f));
        Colors.put("blueviolet", ColorAtom.convColor(0.86f, 0.91f, 0.0f, 0.04f));
        Colors.put("periwinkle", ColorAtom.convColor(0.57f, 0.55f, 0.0f, 0.0f));
        Colors.put("cadetblue", ColorAtom.convColor(0.62f, 0.57f, 0.23f, 0.0f));
        Colors.put("cornflowerblue", ColorAtom.convColor(0.65f, 0.13f, 0.0f, 0.0f));
        Colors.put("midnightblue", ColorAtom.convColor(0.98f, 0.13f, 0.0f, 0.43f));
        Colors.put("navyblue", ColorAtom.convColor(0.94f, 0.54f, 0.0f, 0.0f));
        Colors.put("royalblue", ColorAtom.convColor(1.0f, 0.5f, 0.0f, 0.0f));
        Colors.put("cerulean", ColorAtom.convColor(0.94f, 0.11f, 0.0f, 0.0f));
        Colors.put("processblue", ColorAtom.convColor(0.96f, 0.0f, 0.0f, 0.0f));
        Colors.put("skyblue", ColorAtom.convColor(0.62f, 0.0f, 0.12f, 0.0f));
        Colors.put("turquoise", ColorAtom.convColor(0.85f, 0.0f, 0.2f, 0.0f));
        Colors.put("tealblue", ColorAtom.convColor(0.86f, 0.0f, 0.34f, 0.02f));
        Colors.put("aquamarine", ColorAtom.convColor(0.82f, 0.0f, 0.3f, 0.0f));
        Colors.put("bluegreen", ColorAtom.convColor(0.85f, 0.0f, 0.33f, 0.0f));
        Colors.put("emerald", ColorAtom.convColor(1.0f, 0.0f, 0.5f, 0.0f));
        Colors.put("junglegreen", ColorAtom.convColor(0.99f, 0.0f, 0.52f, 0.0f));
        Colors.put("seagreen", ColorAtom.convColor(0.69f, 0.0f, 0.5f, 0.0f));
        Colors.put("forestgreen", ColorAtom.convColor(0.91f, 0.0f, 0.88f, 0.12f));
        Colors.put("pinegreen", ColorAtom.convColor(0.92f, 0.0f, 0.59f, 0.25f));
        Colors.put("limegreen", ColorAtom.convColor(0.5f, 0.0f, 1.0f, 0.0f));
        Colors.put("yellowgreen", ColorAtom.convColor(0.44f, 0.0f, 0.74f, 0.0f));
        Colors.put("springgreen", ColorAtom.convColor(0.26f, 0.0f, 0.76f, 0.0f));
        Colors.put("olivegreen", ColorAtom.convColor(0.64f, 0.0f, 0.95f, 0.4f));
        Colors.put("rawsienna", ColorAtom.convColor(0.0f, 0.72f, 1.0f, 0.45f));
        Colors.put("sepia", ColorAtom.convColor(0.0f, 0.83f, 1.0f, 0.7f));
        Colors.put("brown", ColorAtom.convColor(0.0f, 0.81f, 1.0f, 0.6f));
        Colors.put("tan", ColorAtom.convColor(0.14f, 0.42f, 0.56f, 0.0f));
        Colors.put("gray", ColorAtom.convColor(0.0f, 0.0f, 0.0f, 0.5f));
    }

    private static int convColor(float c, float m, float y, float k) {
        float kk = 1.0f - k;
        return Color.rgb((int)((int)(255.0f * kk * (1.0f - c))), (int)((int)(255.0f * kk * (1.0f - m))), (int)((int)(255.0f * kk * (1.0f - y))));
    }

    static {
        ColorAtom.initColors();
    }
}

