/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import org.scilab.forge.jlatexmath.core.AjLatexMath;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.Char;
import org.scilab.forge.jlatexmath.core.CharFont;
import org.scilab.forge.jlatexmath.core.FontInfo;
import org.scilab.forge.jlatexmath.core.TeXFormula;

public class CharBox
extends Box {
    private final CharFont cf;
    private final float size;
    private final char[] arr = new char[1];

    public CharBox(Char c) {
        this.cf = c.getCharFont();
        this.size = c.getMetrics().getSize();
        this.width = c.getWidth();
        this.height = c.getHeight();
        this.depth = c.getDepth();
    }

    @Override
    public void draw(Canvas g2, float x, float y) {
        this.drawDebug(g2, x, y);
        g2.save();
        g2.translate(x, y);
        Typeface font = FontInfo.getFont(this.cf.fontId);
        if (this.size != 1.0f) {
            g2.scale(this.size, this.size);
        }
        Paint st = AjLatexMath.getPaint();
        st.setTextSize(TeXFormula.PIXELS_PER_POINT);
        st.setTypeface(font);
        st.setStyle(Paint.Style.FILL);
        st.setAntiAlias(true);
        st.setStrokeWidth(0.0f);
        this.arr[0] = this.cf.c;
        g2.drawText(this.arr, 0, 1, 0.0f, 0.0f, st);
        g2.restore();
    }

    @Override
    public int getLastFontId() {
        return this.cf.fontId;
    }

    public String toString() {
        return super.toString() + "=" + this.cf.c;
    }
}

