/*
 * Decompiled with CFR 0.152.
 */
package com.daquexian.flexiblerichtextview;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.daquexian.flexiblerichtextview.Attachment;
import com.daquexian.flexiblerichtextview.FlexibleRichTextView;
import com.daquexian.flexiblerichtextview.R;
import com.daquexian.flexiblerichtextview.Tokenizer;
import java.util.ArrayList;
import java.util.List;

public class QuoteView
extends LinearLayout {
    TextView mTextView;
    FlexibleRichTextView mFlexibleRichTextView;
    View mButton;
    Boolean mCollapsed;
    Context mContext;
    FlexibleRichTextView.OnViewClickListener mOnButtonClickListener;
    List<Attachment> mAttachmentList = new ArrayList<Attachment>();
    int mLayoutId;
    int mButtonId;
    int mRichTextViewHeight = -1;
    int mTextViewHeight = -1;
    final int HEIGHT_THRESHOLD = 10;
    List<Tokenizer.TOKEN> mTokens;
    private static final String TAG = "QuoteView";

    public QuoteView(Context context) {
        super(context);
        this.init(context, null);
    }

    public QuoteView(Context context, List<Attachment> attachmentList) {
        super(context);
        this.init(context, attachmentList);
    }

    public QuoteView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuoteView(Context context, AttributeSet attributeSet, int defStyleAttr) {
        super(context, attributeSet, defStyleAttr);
        TypedArray array = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.QuoteView, 0, 0);
        try {
            this.mButtonId = array.getResourceId(R.styleable.QuoteView_buttonId, -1);
        }
        finally {
            array.recycle();
        }
        this.init(context, null);
    }

    static QuoteView newInstance(ViewGroup parent, int layoutId) {
        QuoteView quoteView = (QuoteView)LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false);
        quoteView.mLayoutId = layoutId;
        return quoteView;
    }

    private void collapse() {
        this.mTextView.setVisibility(0);
        this.mTextView.setText(this.mTextView.getText());
        this.mTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mFlexibleRichTextView.setVisibility(8);
        this.mCollapsed = true;
    }

    private void expand() {
        this.mTextView.setVisibility(8);
        this.mFlexibleRichTextView.setVisibility(0);
        this.mCollapsed = false;
    }

    private void init(final Context context, final List<Attachment> attachmentList) {
        this.post(new Runnable(){

            @Override
            public void run() {
                QuoteView.this.mContext = context;
                QuoteView.this.mCollapsed = false;
                QuoteView.this.mTextView = new TextView(context);
                QuoteView.this.mFlexibleRichTextView = FlexibleRichTextView.newInstance(context, "", attachmentList, null, false);
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
                QuoteView.this.mTextView.setLayoutParams((ViewGroup.LayoutParams)params);
                QuoteView.this.mTextView.setTextIsSelectable(true);
                QuoteView.this.mTextView.setVisibility(4);
                FrameLayout container = (FrameLayout)QuoteView.this.getChildAt(0);
                container.addView((View)QuoteView.this.mTextView);
                container.addView((View)QuoteView.this.mFlexibleRichTextView);
                QuoteView.this.mButton = QuoteView.this.findViewById(QuoteView.this.mButtonId);
                if (QuoteView.this.mButton != null) {
                    QuoteView.this.mButton.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (QuoteView.this.mCollapsed.booleanValue()) {
                                QuoteView.this.expand();
                            } else {
                                QuoteView.this.collapse();
                            }
                            if (QuoteView.this.mOnButtonClickListener != null) {
                                QuoteView.this.mOnButtonClickListener.onQuoteButtonClick(QuoteView.this.mButton, QuoteView.this.mCollapsed);
                            } else if (QuoteView.this.mLayoutId == R.layout.default_quote_view) {
                                ((Button)QuoteView.this.mButton).setText((CharSequence)QuoteView.this.getResources().getString(QuoteView.this.mCollapsed != false ? R.string.expand : R.string.collapse));
                            }
                        }
                    });
                }
            }
        });
    }

    public void setTokens(final List<Tokenizer.TOKEN> tokens) {
        this.post(new Runnable(){

            @Override
            public void run() {
                QuoteView.this.mTokens = tokens;
                QuoteView.this.mFlexibleRichTextView.setToken(tokens, QuoteView.this.mAttachmentList);
                QuoteView.this.mFlexibleRichTextView.post(new Runnable(){

                    @Override
                    public void run() {
                        QuoteView.this.mRichTextViewHeight = QuoteView.this.mFlexibleRichTextView.getHeight();
                        if (QuoteView.this.mTextViewHeight != -1 && QuoteView.this.mRichTextViewHeight - QuoteView.this.mTextViewHeight < 10) {
                            QuoteView.this.mButton.setVisibility(8);
                        }
                    }
                });
                QuoteView.this.mTextView.setText((CharSequence)Tokenizer.TOKEN.getString(tokens));
                QuoteView.this.mTextView.setMaxLines(3);
                QuoteView.this.mTextView.setEllipsize(TextUtils.TruncateAt.END);
                QuoteView.this.mTextView.post(new Runnable(){

                    @Override
                    public void run() {
                        QuoteView.this.mTextViewHeight = QuoteView.this.mTextView.getHeight();
                        if (QuoteView.this.mRichTextViewHeight != -1 && QuoteView.this.mRichTextViewHeight - QuoteView.this.mTextViewHeight < 10) {
                            QuoteView.this.mButton.setVisibility(8);
                        }
                    }
                });
            }
        });
    }

    public void setAttachmentList(List<Attachment> AttachmentList) {
        this.mAttachmentList = AttachmentList;
    }

    public void setOnButtonClickListener(FlexibleRichTextView.OnViewClickListener onButtonClickListener) {
        this.mOnButtonClickListener = onButtonClickListener;
    }
}

