/*
 * Decompiled with CFR 0.152.
 */
package com.github.dapeng.maven.plugin;

import com.github.dapeng.bootstrap.Bootstrap;
import com.github.dapeng.bootstrap.classloader.ApplicationClassLoader;
import com.github.dapeng.bootstrap.classloader.ContainerClassLoader;
import com.github.dapeng.bootstrap.classloader.CoreClassLoader;
import com.github.dapeng.maven.plugin.SoaAbstractMojo;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class RunContainerPlugin
extends SoaAbstractMojo {
    List<URL> buildRuntimeURLs() {
        URL[] urls;
        ArrayList<URL> results = new ArrayList<URL>();
        List arts = this.project.getRuntimeArtifacts();
        for (Artifact art : arts) {
            try {
                results.add(art.getFile().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        for (URL url : urls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()) {
            if (!url.toString().endsWith("/target/classes/")) continue;
            results.add(0, url);
        }
        return results;
    }

    List<URL> buildPlatformURLs(List<URL> rtURLs) {
        URL[] urls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
        ArrayList<URL> results = new ArrayList<URL>();
        List arts = this.project.getRuntimeArtifacts();
        for (URL url : urls) {
            boolean contains = false;
            if (contains) continue;
            results.add(url);
        }
        return results;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project == null) {
            throw new MojoExecutionException("not found project.");
        }
        this.getLog().info((CharSequence)("bundle:" + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion()));
        System.setProperty("soa.base", new File(this.project.getBuild().getOutputDirectory()).getAbsolutePath().replace("/target/classes", ""));
        System.setProperty("soa.run.mode", "plugin");
        SoaAbstractMojo.IsolatedThreadGroup threadGroup = new SoaAbstractMojo.IsolatedThreadGroup("RunContainerPlugin");
        Thread bootstrapThread = new Thread(threadGroup, () -> {
            try {
                List<URL> rtURLs = this.buildRuntimeURLs();
                List<URL> platformURLs = this.buildPlatformURLs(rtURLs);
                URL[] urls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
                CoreClassLoader coreClassLoader = new CoreClassLoader(platformURLs.toArray(new URL[platformURLs.size()]));
                ContainerClassLoader containerClassLoader = new ContainerClassLoader(new URL[0], (ClassLoader)coreClassLoader);
                ApplicationClassLoader appClassLoader = new ApplicationClassLoader(rtURLs.toArray(new URL[rtURLs.size()]), null, (ClassLoader)coreClassLoader);
                ArrayList<ApplicationClassLoader> appClassLoaders = new ArrayList<ApplicationClassLoader>();
                appClassLoaders.add(appClassLoader);
                System.out.println("------set classloader-------------");
                Thread.currentThread().setContextClassLoader((ClassLoader)appClassLoader);
                Bootstrap.startup((ClassLoader)containerClassLoader, appClassLoaders);
            }
            catch (Exception e) {
                Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), e);
            }
        }, "RunContainerPlugin.main()");
        bootstrapThread.setContextClassLoader(this.getClassLoader());
        bootstrapThread.start();
        this.joinNonDaemonThreads(threadGroup);
    }
}

