/*
 * Decompiled with CFR 0.152.
 */
package com.github.dapeng.maven.plugin;

import com.github.dapeng.bootstrap.Bootstrap;
import com.github.dapeng.bootstrap.classloader.ApplicationClassLoader;
import com.github.dapeng.bootstrap.classloader.ContainerClassLoader;
import com.github.dapeng.bootstrap.classloader.CoreClassLoader;
import com.github.dapeng.maven.plugin.SoaAbstractMojo;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class RunContainerPlugin
extends SoaAbstractMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project == null) {
            throw new MojoExecutionException("not found project.");
        }
        this.getLog().info((CharSequence)("bundle:" + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion()));
        System.setProperty("soa.base", new File(this.project.getBuild().getOutputDirectory()).getAbsolutePath().replace("/target/classes", ""));
        System.setProperty("soa.run.mode", "plugin");
        SoaAbstractMojo.IsolatedThreadGroup threadGroup = new SoaAbstractMojo.IsolatedThreadGroup("RunContainerPlugin");
        Thread bootstrapThread = new Thread(threadGroup, () -> {
            try {
                URL[] urls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
                ArrayList<URL> shareUrls = new ArrayList<URL>(Arrays.asList(urls));
                Iterator<URL> iterator = shareUrls.iterator();
                while (iterator.hasNext()) {
                    URL url = (URL)iterator.next();
                    if (!url.getFile().matches("^.*/dapeng-transaction-impl.*\\.jar$")) continue;
                    iterator.remove();
                }
                ArrayList<URL> platformUrls = new ArrayList<URL>(Arrays.asList(urls));
                iterator = platformUrls.iterator();
                while (iterator.hasNext()) {
                    URL url = (URL)iterator.next();
                    if (!this.removeServiceProjectArtifact(iterator, url)) continue;
                }
                ArrayList<URL> appUrls = new ArrayList<URL>(Arrays.asList(urls));
                iterator = appUrls.iterator();
                while (iterator.hasNext()) {
                    URL url = iterator.next();
                    if (!this.removeTwitterAndScalaDependency(iterator, url) && !this.removeContainerAndBootstrap(iterator, url)) continue;
                }
                ArrayList<ArrayList<URL>> appURLsList = new ArrayList<ArrayList<URL>>();
                appURLsList.add(appUrls);
                CoreClassLoader coreClassLoader = new CoreClassLoader(shareUrls.toArray(new URL[shareUrls.size()]));
                List appClassLoaders = appURLsList.stream().map(i -> new ApplicationClassLoader(i.toArray(new URL[i.size()]), (ClassLoader)coreClassLoader)).collect(Collectors.toList());
                ContainerClassLoader platformClassLoader = new ContainerClassLoader(platformUrls.toArray(new URL[platformUrls.size()]), (ClassLoader)coreClassLoader);
                System.out.println("------set classloader-------------");
                Thread.currentThread().setContextClassLoader((ClassLoader)coreClassLoader);
                Bootstrap.startup((ClassLoader)platformClassLoader, appClassLoaders);
            }
            catch (Exception e) {
                Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), e);
            }
        }, "RunContainerPlugin.main()");
        bootstrapThread.setContextClassLoader(this.getClassLoader());
        bootstrapThread.start();
        this.joinNonDaemonThreads(threadGroup);
    }

    private boolean removeServiceProjectArtifact(Iterator<URL> iterator, URL url) {
        String regex = this.project.getArtifact().getFile().getAbsolutePath().replaceAll("\\\\", "/");
        if ("\\".equals(File.separator)) {
            regex = regex.replace(File.separator, File.separator + File.separator);
        }
        if (url.getFile().matches("^.*" + regex + ".*$")) {
            iterator.remove();
            return true;
        }
        return false;
    }

    private boolean removeTwitterAndScalaDependency(Iterator<URL> iterator, URL url) {
        if (url.getFile().matches("^.*/twitter.*\\.jar$")) {
            iterator.remove();
            return true;
        }
        return false;
    }

    private boolean removeContainerAndBootstrap(Iterator<URL> iterator, URL url) {
        if (url.getFile().matches("^.*/dapeng-container-api.*\\.jar$")) {
            iterator.remove();
            return true;
        }
        if (url.getFile().matches("^.*/dapeng-container-impl.*\\.jar$")) {
            iterator.remove();
            return true;
        }
        if (url.getFile().matches("^.*/dapeng-bootstrap.*\\.jar$")) {
            iterator.remove();
            return true;
        }
        return false;
    }
}

