/*
 * Decompiled with CFR 0.152.
 */
package com.volokh.danylo.video_player_manager.ui;

import android.util.Pair;
import com.volokh.danylo.video_player_manager.utils.Logger;

public class ReadyForPlaybackIndicator {
    private static final String TAG = ReadyForPlaybackIndicator.class.getSimpleName();
    private static final boolean SHOW_LOGS = true;
    private Pair<Integer, Integer> mVideoSize;
    private boolean mSurfaceTextureAvailable;
    private boolean mFailedToPrepareUiForPlayback = false;

    public boolean isVideoSizeAvailable() {
        boolean isVideoSizeAvailable = this.mVideoSize.first != null && this.mVideoSize.second != null;
        Logger.v(TAG, "isVideoSizeAvailable " + isVideoSizeAvailable);
        return isVideoSizeAvailable;
    }

    public boolean isSurfaceTextureAvailable() {
        Logger.v(TAG, "isSurfaceTextureAvailable " + this.mSurfaceTextureAvailable);
        return this.mSurfaceTextureAvailable;
    }

    public boolean isReadyForPlayback() {
        boolean isReadyForPlayback = this.isVideoSizeAvailable() && this.isSurfaceTextureAvailable();
        Logger.v(TAG, "isReadyForPlayback " + isReadyForPlayback);
        return isReadyForPlayback;
    }

    public void setSurfaceTextureAvailable(boolean available) {
        this.mSurfaceTextureAvailable = available;
    }

    public void setVideoSize(Integer videoHeight, Integer videoWidth) {
        this.mVideoSize = new Pair((Object)videoHeight, (Object)videoWidth);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.isReadyForPlayback();
    }

    public void setFailedToPrepareUiForPlayback(boolean failed) {
        this.mFailedToPrepareUiForPlayback = failed;
    }

    public boolean isFailedToPrepareUiForPlayback() {
        return this.mFailedToPrepareUiForPlayback;
    }
}

