/*
 * Decompiled with CFR 0.152.
 */
package com.volokh.danylo.video_player_manager.manager;

import android.content.res.AssetFileDescriptor;
import com.volokh.danylo.video_player_manager.MessagesHandlerThread;
import com.volokh.danylo.video_player_manager.PlayerMessageState;
import com.volokh.danylo.video_player_manager.SetNewViewForPlayback;
import com.volokh.danylo.video_player_manager.manager.PlayerItemChangeListener;
import com.volokh.danylo.video_player_manager.manager.VideoPlayerManager;
import com.volokh.danylo.video_player_manager.manager.VideoPlayerManagerCallback;
import com.volokh.danylo.video_player_manager.meta.MetaData;
import com.volokh.danylo.video_player_manager.player_messages.ClearPlayerInstance;
import com.volokh.danylo.video_player_manager.player_messages.CreateNewPlayerInstance;
import com.volokh.danylo.video_player_manager.player_messages.Prepare;
import com.volokh.danylo.video_player_manager.player_messages.Release;
import com.volokh.danylo.video_player_manager.player_messages.Reset;
import com.volokh.danylo.video_player_manager.player_messages.SetAssetsDataSourceMessage;
import com.volokh.danylo.video_player_manager.player_messages.SetUrlDataSourceMessage;
import com.volokh.danylo.video_player_manager.player_messages.Start;
import com.volokh.danylo.video_player_manager.player_messages.Stop;
import com.volokh.danylo.video_player_manager.ui.MediaPlayerWrapper;
import com.volokh.danylo.video_player_manager.ui.VideoPlayerView;
import com.volokh.danylo.video_player_manager.utils.Logger;
import java.util.Arrays;

public class SingleVideoPlayerManager
implements VideoPlayerManager<MetaData>,
VideoPlayerManagerCallback,
MediaPlayerWrapper.MainThreadMediaPlayerListener {
    private static final String TAG = SingleVideoPlayerManager.class.getSimpleName();
    private static final boolean SHOW_LOGS = true;
    private final MessagesHandlerThread mPlayerHandler = new MessagesHandlerThread();
    private final PlayerItemChangeListener mPlayerItemChangeListener;
    private VideoPlayerView mCurrentPlayer = null;
    private PlayerMessageState mCurrentPlayerState = PlayerMessageState.IDLE;

    public SingleVideoPlayerManager(PlayerItemChangeListener playerItemChangeListener) {
        this.mPlayerItemChangeListener = playerItemChangeListener;
    }

    @Override
    public void playNewVideo(MetaData currentItemMetaData, VideoPlayerView videoPlayerView, String videoUrl) {
        Logger.v(TAG, ">> playNewVideo, videoPlayer " + videoPlayerView + ", mCurrentPlayer " + this.mCurrentPlayer + ", videoPlayerView " + videoPlayerView);
        this.mPlayerHandler.pauseQueueProcessing(TAG);
        boolean currentPlayerIsActive = this.mCurrentPlayer == videoPlayerView;
        boolean isAlreadyPlayingTheFile = this.mCurrentPlayer != null && videoUrl.equals(this.mCurrentPlayer.getVideoUrlDataSource());
        Logger.v(TAG, "playNewVideo, isAlreadyPlayingTheFile " + isAlreadyPlayingTheFile);
        Logger.v(TAG, "playNewVideo, currentPlayerIsActive " + currentPlayerIsActive);
        if (currentPlayerIsActive) {
            if (this.isInPlaybackState() && isAlreadyPlayingTheFile) {
                Logger.v(TAG, "playNewVideo, videoPlayer " + videoPlayerView + " is already in state " + (Object)((Object)this.mCurrentPlayerState));
            } else {
                this.startNewPlayback(currentItemMetaData, videoPlayerView, videoUrl);
            }
        } else {
            this.startNewPlayback(currentItemMetaData, videoPlayerView, videoUrl);
        }
        this.mPlayerHandler.resumeQueueProcessing(TAG);
        Logger.v(TAG, "<< playNewVideo, videoPlayer " + videoPlayerView + ", videoUrl " + videoUrl);
    }

    @Override
    public void playNewVideo(MetaData currentItemMetaData, VideoPlayerView videoPlayerView, AssetFileDescriptor assetFileDescriptor) {
        Logger.v(TAG, ">> playNewVideo, videoPlayer " + videoPlayerView + ", mCurrentPlayer " + this.mCurrentPlayer + ", assetFileDescriptor " + assetFileDescriptor);
        Logger.v(TAG, "playNewVideo, currentItemMetaData " + currentItemMetaData);
        this.mPlayerHandler.pauseQueueProcessing(TAG);
        boolean currentPlayerIsActive = this.mCurrentPlayer == videoPlayerView;
        boolean isAlreadyPlayingTheFile = this.mCurrentPlayer != null && this.mCurrentPlayer.getAssetFileDescriptorDataSource() == assetFileDescriptor;
        Logger.v(TAG, "playNewVideo, isAlreadyPlayingTheFile " + isAlreadyPlayingTheFile);
        Logger.v(TAG, "playNewVideo, currentPlayerIsActive " + currentPlayerIsActive);
        if (currentPlayerIsActive) {
            if (this.isInPlaybackState() && isAlreadyPlayingTheFile) {
                Logger.v(TAG, "playNewVideo, videoPlayer " + videoPlayerView + " is already in state " + (Object)((Object)this.mCurrentPlayerState));
            } else {
                this.startNewPlayback(currentItemMetaData, videoPlayerView, assetFileDescriptor);
            }
        } else {
            this.startNewPlayback(currentItemMetaData, videoPlayerView, assetFileDescriptor);
        }
        this.mPlayerHandler.resumeQueueProcessing(TAG);
        Logger.v(TAG, "<< playNewVideo, videoPlayer " + videoPlayerView + ", assetFileDescriptor " + assetFileDescriptor);
    }

    private boolean isInPlaybackState() {
        boolean isPlaying = this.mCurrentPlayerState == PlayerMessageState.STARTED || this.mCurrentPlayerState == PlayerMessageState.STARTING;
        Logger.v(TAG, "isInPlaybackState, " + isPlaying);
        return isPlaying;
    }

    private void startNewPlayback(MetaData currentItemMetaData, VideoPlayerView videoPlayerView, AssetFileDescriptor assetFileDescriptor) {
        videoPlayerView.addMediaPlayerListener(this);
        Logger.v(TAG, "startNewPlayback, mCurrentPlayerState " + (Object)((Object)this.mCurrentPlayerState));
        this.mPlayerHandler.clearAllPendingMessages(TAG);
        this.stopResetReleaseClearCurrentPlayer();
        this.setNewViewForPlayback(currentItemMetaData, videoPlayerView);
        this.startPlayback(videoPlayerView, assetFileDescriptor);
    }

    private void startNewPlayback(MetaData currentItemMetaData, VideoPlayerView videoPlayerView, String videoUrl) {
        videoPlayerView.addMediaPlayerListener(this);
        Logger.v(TAG, "startNewPlayback, mCurrentPlayerState " + (Object)((Object)this.mCurrentPlayerState));
        this.mPlayerHandler.clearAllPendingMessages(TAG);
        this.stopResetReleaseClearCurrentPlayer();
        this.setNewViewForPlayback(currentItemMetaData, videoPlayerView);
        this.startPlayback(videoPlayerView, videoUrl);
    }

    @Override
    public void stopAnyPlayback() {
        Logger.v(TAG, ">> stopAnyPlayback, mCurrentPlayerState " + (Object)((Object)this.mCurrentPlayerState));
        this.mPlayerHandler.pauseQueueProcessing(TAG);
        Logger.v(TAG, "stopAnyPlayback, mCurrentPlayerState " + (Object)((Object)this.mCurrentPlayerState));
        this.mPlayerHandler.clearAllPendingMessages(TAG);
        this.stopResetReleaseClearCurrentPlayer();
        this.mPlayerHandler.resumeQueueProcessing(TAG);
        Logger.v(TAG, "<< stopAnyPlayback, mCurrentPlayerState " + (Object)((Object)this.mCurrentPlayerState));
    }

    @Override
    public void resetMediaPlayer() {
        Logger.v(TAG, ">> resetMediaPlayer, mCurrentPlayerState " + (Object)((Object)this.mCurrentPlayerState));
        this.mPlayerHandler.pauseQueueProcessing(TAG);
        Logger.v(TAG, "resetMediaPlayer, mCurrentPlayerState " + (Object)((Object)this.mCurrentPlayerState));
        this.mPlayerHandler.clearAllPendingMessages(TAG);
        this.resetReleaseClearCurrentPlayer();
        this.mPlayerHandler.resumeQueueProcessing(TAG);
        Logger.v(TAG, "<< resetMediaPlayer, mCurrentPlayerState " + (Object)((Object)this.mCurrentPlayerState));
    }

    private void startPlayback(VideoPlayerView videoPlayerView, String videoUrl) {
        Logger.v(TAG, "startPlayback");
        this.mPlayerHandler.addMessages(Arrays.asList(new CreateNewPlayerInstance(videoPlayerView, this), new SetUrlDataSourceMessage(videoPlayerView, videoUrl, this), new Prepare(videoPlayerView, this), new Start(videoPlayerView, this)));
    }

    private void startPlayback(VideoPlayerView videoPlayerView, AssetFileDescriptor assetFileDescriptor) {
        Logger.v(TAG, "startPlayback");
        this.mPlayerHandler.addMessages(Arrays.asList(new CreateNewPlayerInstance(videoPlayerView, this), new SetAssetsDataSourceMessage(videoPlayerView, assetFileDescriptor, this), new Prepare(videoPlayerView, this), new Start(videoPlayerView, this)));
    }

    private void setNewViewForPlayback(MetaData currentItemMetaData, VideoPlayerView videoPlayerView) {
        Logger.v(TAG, "setNewViewForPlayback, currentItemMetaData " + currentItemMetaData + ", videoPlayer " + videoPlayerView);
        this.mPlayerHandler.addMessage(new SetNewViewForPlayback(currentItemMetaData, videoPlayerView, this));
    }

    private void stopResetReleaseClearCurrentPlayer() {
        Logger.v(TAG, "stopResetReleaseClearCurrentPlayer, mCurrentPlayerState " + (Object)((Object)this.mCurrentPlayerState) + ", mCurrentPlayer " + this.mCurrentPlayer);
        switch (this.mCurrentPlayerState) {
            case SETTING_NEW_PLAYER: 
            case IDLE: 
            case CREATING_PLAYER_INSTANCE: 
            case PLAYER_INSTANCE_CREATED: 
            case CLEARING_PLAYER_INSTANCE: 
            case PLAYER_INSTANCE_CLEARED: {
                break;
            }
            case INITIALIZED: 
            case PREPARING: 
            case PREPARED: 
            case STARTING: 
            case STARTED: 
            case PAUSING: 
            case PAUSED: {
                this.mPlayerHandler.addMessage(new Stop(this.mCurrentPlayer, this));
            }
            case SETTING_DATA_SOURCE: 
            case DATA_SOURCE_SET: 
            case STOPPING: 
            case STOPPED: 
            case ERROR: 
            case PLAYBACK_COMPLETED: {
                this.mPlayerHandler.addMessage(new Reset(this.mCurrentPlayer, this));
            }
            case RESETTING: 
            case RESET: {
                this.mPlayerHandler.addMessage(new Release(this.mCurrentPlayer, this));
            }
            case RELEASING: 
            case RELEASED: {
                this.mPlayerHandler.addMessage(new ClearPlayerInstance(this.mCurrentPlayer, this));
                break;
            }
            case END: {
                throw new RuntimeException("unhandled " + (Object)((Object)this.mCurrentPlayerState));
            }
        }
    }

    private void resetReleaseClearCurrentPlayer() {
        Logger.v(TAG, "resetReleaseClearCurrentPlayer, mCurrentPlayerState " + (Object)((Object)this.mCurrentPlayerState) + ", mCurrentPlayer " + this.mCurrentPlayer);
        switch (this.mCurrentPlayerState) {
            case SETTING_NEW_PLAYER: 
            case IDLE: 
            case CREATING_PLAYER_INSTANCE: 
            case PLAYER_INSTANCE_CREATED: 
            case CLEARING_PLAYER_INSTANCE: 
            case PLAYER_INSTANCE_CLEARED: 
            case SETTING_DATA_SOURCE: 
            case DATA_SOURCE_SET: {
                break;
            }
            case INITIALIZED: 
            case PREPARING: 
            case PREPARED: 
            case STARTING: 
            case STARTED: 
            case PAUSING: 
            case PAUSED: 
            case STOPPING: 
            case STOPPED: 
            case ERROR: 
            case PLAYBACK_COMPLETED: {
                this.mPlayerHandler.addMessage(new Reset(this.mCurrentPlayer, this));
            }
            case RESETTING: 
            case RESET: {
                this.mPlayerHandler.addMessage(new Release(this.mCurrentPlayer, this));
            }
            case RELEASING: 
            case RELEASED: {
                this.mPlayerHandler.addMessage(new ClearPlayerInstance(this.mCurrentPlayer, this));
                break;
            }
            case END: {
                throw new RuntimeException("unhandled " + (Object)((Object)this.mCurrentPlayerState));
            }
        }
    }

    @Override
    public void setCurrentItem(MetaData currentItemMetaData, VideoPlayerView videoPlayerView) {
        Logger.v(TAG, ">> onPlayerItemChanged");
        this.mCurrentPlayer = videoPlayerView;
        this.mPlayerItemChangeListener.onPlayerItemChanged(currentItemMetaData);
        Logger.v(TAG, "<< onPlayerItemChanged");
    }

    @Override
    public void setVideoPlayerState(VideoPlayerView videoPlayerView, PlayerMessageState playerMessageState) {
        Logger.v(TAG, ">> setVideoPlayerState, playerMessageState " + (Object)((Object)playerMessageState) + ", videoPlayer " + videoPlayerView);
        this.mCurrentPlayerState = playerMessageState;
        Logger.v(TAG, "<< setVideoPlayerState, playerMessageState " + (Object)((Object)playerMessageState) + ", videoPlayer " + videoPlayerView);
    }

    @Override
    public PlayerMessageState getCurrentPlayerState() {
        Logger.v(TAG, "getCurrentPlayerState, mCurrentPlayerState " + (Object)((Object)this.mCurrentPlayerState));
        return this.mCurrentPlayerState;
    }

    @Override
    public void onVideoSizeChangedMainThread(int width, int height) {
    }

    @Override
    public void onVideoPreparedMainThread() {
    }

    @Override
    public void onVideoCompletionMainThread() {
        this.mCurrentPlayerState = PlayerMessageState.PLAYBACK_COMPLETED;
    }

    @Override
    public void onErrorMainThread(int what, int extra) {
        Logger.v(TAG, "onErrorMainThread, what " + what + ", extra " + extra);
        this.mCurrentPlayerState = PlayerMessageState.ERROR;
    }

    @Override
    public void onBufferingUpdateMainThread(int percent) {
    }

    @Override
    public void onVideoStoppedMainThread() {
    }
}

