/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.Clock;
import com.github.danielflower.mavenplugins.release.ValidationException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.lib.Repository;

public class VersionNamer {
    private final Clock clock;

    public VersionNamer(Clock clock) {
        this.clock = clock;
    }

    public String name(String pomVersion, String buildNumber) throws ValidationException {
        if (buildNumber == null || buildNumber.trim().length() == 0) {
            buildNumber = this.currentDate();
        }
        String newVersion = pomVersion.replace("-SNAPSHOT", "").concat(".").concat(buildNumber);
        if (!Repository.isValidRefName((String)("refs/tags/" + newVersion))) {
            String summary = "Sorry, '" + newVersion + "' is not a valid version.";
            throw new ValidationException(summary, Arrays.asList(summary, "Version numbers are used in the Git tag, and so can only contain characters that are valid in git tags.", "Please see https://www.kernel.org/pub/software/scm/git/docs/git-check-ref-format.html for tag naming rules."));
        }
        return newVersion;
    }

    private String currentDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ROOT);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(this.clock.now());
    }
}

