/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.Clock;
import com.github.danielflower.mavenplugins.release.ReleasableModule;
import com.github.danielflower.mavenplugins.release.ValidationException;
import com.github.danielflower.mavenplugins.release.VersionNamer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class Reactor {
    private final List<ReleasableModule> modulesInBuildOrder;

    public Reactor(List<ReleasableModule> modulesInBuildOrder) {
        this.modulesInBuildOrder = modulesInBuildOrder;
    }

    public List<ReleasableModule> getModulesInBuildOrder() {
        return this.modulesInBuildOrder;
    }

    public static Reactor fromProjects(List<MavenProject> projects, String buildNumber) throws ValidationException {
        ArrayList<ReleasableModule> modules = new ArrayList<ReleasableModule>();
        VersionNamer versionNamer = new VersionNamer(Clock.SystemClock);
        for (MavenProject project : projects) {
            modules.add(new ReleasableModule(project, buildNumber, versionNamer));
        }
        return new Reactor(modules);
    }

    public ReleasableModule find(String searchingFrom, String groupId, String artifactId) throws ValidationException {
        for (ReleasableModule module : this.modulesInBuildOrder) {
            if (!module.getGroupId().equals(groupId) || !module.getArtifactId().equals(artifactId)) continue;
            return module;
        }
        String summary = "The artifact " + groupId + ":" + artifactId + " referenced from " + searchingFrom + " is a SNAPSHOT in your project however it was not found";
        throw new ValidationException(summary, Arrays.asList(summary));
    }
}

